<?php

namespace App\Http\Controllers\user;

use Validator;
use App\Models\User;
use App\Models\Order;
use App\Models\Payment;
use App\Models\Setting;
use App\Models\Voucher;
use App\Models\Variation;
use App\Models\Uddoktapay;
use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Http\Controllers\Controller;
use App\Notifications\OrderComplete;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Notification;
use App\Jobs\SendWhatsAppMessage;
class PageController extends Controller
{
    public function fund()
    {
        return view('frontend.fund');
    }

    public function orderList(Request $request)
    {
        $query = Order::query();

        // Filter by authenticated user's orders only
        $query->where('user_id', auth()->id());

        // Filter by order code if provided
        if (!empty($request->key)) {
            $query->where('code', 'like', '%' . $request->key . '%');
        }

        // Filter by date range if both dates are provided
        if (!empty($request->from) && !empty($request->to)) {
            $query->whereBetween('created_at', [$request->from, $request->to]);
        }

        // Filter specifically for voucher type
        $query->whereIn('type', ['topup', 'ingame']);

        // Order the results by ID in descending order
        $orders = $query->orderBy('id', 'desc')->paginate(15);

        return view('frontend.order', compact('orders'));
    }

    public function voucherOrder(Request $request)
    {
        $query = Order::query();

        // Filter by authenticated user's orders only
        $query->where('user_id', auth()->id());

        // Filter by order code if provided
        if (!empty($request->key)) {
            $query->orWhere('code', 'like', '%' . $request->key . '%');
        }

        // Filter by date range if both dates are provided
        if (!empty($request->from) && !empty($request->to)) {
            $query->whereBetween('created_at', [$request->from, $request->to]);
        }

        // Filter specifically for voucher type
        $query->where('type', 'voucher');

        // Order the results by ID in descending order
        $orders = $query->orderBy('id', 'desc')->paginate(15);

        return view('frontend.voucharOrder', compact('orders'));
    } // Endmethod

    public function order(Request $request)
    {
        if ($request->type == 'ingame') {
            $validator = Validator::make($request->all(), [
                'game_account_type' => 'required',
                'game_account' => 'required',
                'game_password' => 'required',
                'game_backup' => 'required',
                'variation_id' => 'required',
            ]);

            if ($validator->fails()) {
                if ($validator->fails()) {
                    return response()->json(['message' => $validator->errors()->first()], 200);
                }
            }
        }

        if ($request->type == 'topup') {
            $validator = Validator::make($request->all(), [
                'player_id' => 'required',
                'variation_id' => 'required',
            ]);

            if ($validator->fails()) {
                $errors = $validator->errors();
                if ($errors->has('player_id')) {
                    return response()->json(['message' => $errors->first('player_id')], 200);
                }
                if ($errors->has('variation_id')) {
                    return response()->json(['message' => 'Please select recharge'], 200);
                }
            }

            $variation = Variation::find($request->variation_id);
            if ($variation->automatic != null) {
                $ckvoucher = Voucher::where('variation', $request->variation_id)
                    ->where('status', 0)
                    ->count();

                if ($request->quantity > $ckvoucher) {
                    return response()->json(['message' => 'Quantity left ' . $ckvoucher], 200);
                }
            }
        }

        if ($request->type == 'voucher') {
            $validator = Validator::make($request->all(), [
                'variation_id' => 'required',
                'quantity' => 'min:1',
            ]);

            if ($validator->fails()) {
                $errors = $validator->errors();
                if ($errors->has('variation_id')) {
                    return response()->json(['message' => 'Please select recharge'], 200);
                }
            }

            $variation = Variation::find($request->variation_id);
            $voucher = Voucher::where('variation', $request->variation_id)
                ->where('status', 0)
                ->count();
            if ($request->quantity > $voucher) {
                return response()->json(['message' => 'Quantity left ' . $voucher], 200);
            }
        }

        $variation = Variation::find($request->variation_id);
        if (!isset($variation)) {
            return response()->json(['message' => 'Something went wrong'], 200);
        }

        if ($request->quantity > $variation->stock) {
            return response()->json(['message' => 'Quantity left ' . $variation->stock], 200);
        }

        $totalCrg = $request->quantity * $variation->price;
        if ($request->payment_method == 'wallet') {
            if (Auth::user()->balance < $totalCrg) {
                return response()->json(['message' => 'Insufficient Balance'], 200);
            }
        }

        // Decrease stock by the total quantity ordered
        if ($request->payment_method == 'wallet') {
            $variation->stock = $variation->stock - $request->quantity;
        }
        $variation->save();

        // Deduct the total amount from user balance
        $user = User::find(Auth::user()->id);
        if ($request->payment_method == 'wallet') {
            $user->balance = $user->balance - $totalCrg;
        }
        $user->save();

        // Create a unique order summary ID

        $ordersumId = time(); // Example: 3495303455
        $orderIds = []; // Array to hold created order IDs
        $usedVoucherIds = [];
        for ($i = 0; $i < $request->quantity; $i++) {
            $voucher = Voucher::where('variation', $request->variation_id)
                ->where('status', 0)
                ->whereNotIn('id', $usedVoucherIds)
                ->first();
            if (isset($voucher) && $voucher->status == 0) {
                $usedVoucherIds[] = $voucher->id;
                $voucher->status = 1;
                $voucher->save();
            }

            $order = new Order();
            $order->user_id = Auth::user()->id;
            $order->product_id = $variation->product_id;
            $order->order_sumid = $ordersumId;
            $order->variation_id = $variation->id;
            $order->type = $request->type;
            $order->single_price = $variation->price;
            $order->total_price = $variation->price; // Each order is for one item
            $order->player_id = $request->player_id;
            $order->qty = 1; // Each loop creates a single order with quantity 1
            $order->payment_type = $request->payment_method;

            $order->game_account_type = $request->game_account_type;
            $order->game_account = $request->game_account;
            $order->game_password = $request->game_password;
            $order->game_backup = $request->game_backup;

            if (isset($voucher)) {
                $order->voucher_id = $voucher->id;
                $order->automatic = $voucher->automatic;

                if ($request->payment_method == 'wallet' && $request->type == 'voucher') {
                    $order->status = '2';
                    $voucher->status = 1;
                }
                if ($request->payment_method == 'wallet' && $request->type == 'topup') {
                    $order->status = '1';
                    $voucher->status = 1;
                }
                $voucher->save();
            } else {
                if (isset($voucher)) {
                    $voucher->status = 0;
                    $voucher->save();
                }
            }

            if ($request->payment_method == 'wallet' && $request->type == 'topup') {
                $order->status = '1';
            }
       //IN GAME Ridoy added if condition
            if ($request->payment_method == 'wallet' && $request->type == 'ingame') {
                $order->status = '1';
            }


            $order->save();
            $orderIds[] = $order->id; // Store the created order ID

           // Dispatch with 2-second delay
SendWhatsAppMessage::dispatch($order)
->delay(now()->addSeconds(2)); 

        }

        //check if not wallet payment
        //$type = 'uddoktapay';

        // Check payment gateways
        $greenPay = PaymentGateway::where('type', 'greenpaybd')->first();
        $UddoktaPay = PaymentGateway::where('type', 'uddoktapay')->first();
        $drutopay = PaymentGateway::where('type', 'drutopay')->first();

        // If both payment gateways are inactive
        if (!isset($greenPay) && !isset($UddoktaPay) && !isset($drutopay)) {
            return response()->json(['message' => 'Payment Method Now not available'], 200);
        }

        // GreenPay Gateway
        if ($request->payment_method !== 'wallet' && $greenPay->is_active == true) {
            // Define payment details for GreenPay
            $api = $greenPay->api_key;
            $client = $greenPay->client;
            $secret = $greenPay->secret;
            $amount = $totalCrg;
            $position = $greenPay->base_url;

            // Retrieve authenticated user's information
            $customer = auth()->user()->name;
            $customerEmail = auth()->user()->email;

            // Define the URLs
            $successUrl = route('successPage', ['amount' => $amount]);
            $cancelUrl = route('greenpay.cancel');

            // Create the payment record
            $payment = new Payment();
            $payment->user_id = Auth::user()->id;
            $payment->amount = $amount;
            $payment->payment_status = 'pending';
            $payment->transaction_id = uniqid();

            // Associate the last created order ID with the payment
            $payment->order_id = end($orderIds); // Get the last order ID
            $payment->save();

            // Store the transaction ID in session
            session(['payment_idx' => $payment->id]); // Store the payment ID in session
            // Store the transaction ID in session to use later

            session(['order_sumid' => $ordersumId]);

            // Construct the payment URL
            $paymentUrl = "https://pay.greenpaybd.com/woocommerce_checkout.php?api=$api&client=$client&secret=$secret&amount=$amount&position=$position&success_url=$successUrl&cancel_url=$cancelUrl&cus_name=" . urlencode($customer) . '&cus_email=' . urlencode($customerEmail) . '&done';

            // Redirect to payment URL
            return response()->json(
                [
                    'message' => 'Recharge successfully',
                    'location' => $paymentUrl,
                ],
                200,
            );
        }

        // Handle UddoktaPay payments
        if ($request->payment_method !== 'wallet' && $UddoktaPay->is_active == true) {
            $baseURL = $UddoktaPay->base_url;
            $apiKEY = $UddoktaPay->api_key;

            $fields = [
                'full_name' => Auth::user()->name,
                'email' => Auth::user()->email,
                'amount' => $totalCrg,
                'metadata' => [
                    'user_id' => Auth::user()->id,
                    'order_id' => $ordersumId,
                ],
                'redirect_url' => url('uddoktapay/success'),
                'return_type' => 'GET',
                'cancel_url' => url('uddoktapay/cancel'),
                'webhook_url' => url('uddoktapay/webhook'),
            ];

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => $baseURL . 'api/checkout-v2',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($fields),
                CURLOPT_HTTPHEADER => ['RT-UDDOKTAPAY-API-KEY: ' . $apiKEY, 'accept: application/json', 'content-type: application/json'],
            ]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                echo 'cURL Error #:' . $err;
            } else {
                $order = new Payment();
                $order->user_id = Auth::user()->id;
                $order->amount = $totalCrg;
                $order->payment_status = 'pending';
                $order->transaction_id = uniqid();
                $order->order_id = end($orderIds);
                $order->save();

                session(['payment_idx' => $order->id]);

                $responseData = json_decode($response, true);

                return response()->json(
                    [
                        'message' => 'Recharge successfully',
                        'location' => $responseData['payment_url'],
                    ],
                    200,
                );
            }
        }

        // drutopay
        if ($request->payment_method !== 'wallet' && $drutopay->is_active == true) {
            session(['order_sumid' => $ordersumId]);

            $gateway = PaymentGateway::where('type', 'drutopay')->where('is_active', 1)->first();

            if (!$gateway) {
                return response()->json(['status' => false, 'message' => 'Active Drutopay gateway not found'], 404);
            }

            // Get authenticated user details
            $user = Auth::user();
            if (!$user) {
                return response()->json(['status' => false, 'message' => 'User not authenticated'], 401);
            }

            // Prepare request parameters
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://pay.drutopay.com/api/payment/create',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{"success_url":"' . url('drutopay/success') . '","cancel_url":"' . url('drutopay/cancel') . '","metadata":{"phone":"' . Auth::user()->phone . '","order_id":"' . 5 . '"},"amount":"' . $totalCrg . '"}',
                CURLOPT_HTTPHEADER => ['API-KEY: ' . $drutopay->api_key . '', 'Content-Type: application/json', 'SECRET-KEY: ' . $drutopay->secret . '', 'BRAND-KEY: ' . $drutopay->client . ''],
            ]);

            $response = curl_exec($curl);

            curl_close($curl);
            $data = json_decode($response, true);

            return response()->json(
                [
                    'message' => 'Recharge successfully',
                    'location' => $data['payment_url'],
                ],
                200,
            );
        }

        // if wallet payment
        if ($request->payment_method == 'wallet') {
            if ($request->type == 'topup') {
                $location = url('user/orders');
            } elseif ($request->type == 'voucher') {
                $location = url('user/voucher');
            }else{
                $location = url('user/orders');
            }
            $user = User::where('type', 'admin')->first();
            Notification::send($user, new OrderComplete($request->name));

            return response()->json(
                [
                    'message' => 'Recharge Redirect successfully',
                    'location' => $location,
                ],
                200,
            );
        }
    }

    public function transactions(Request $request)
    {
        $gateway = PaymentGateway::where('is_active', 1)->first(); // Fetch active gateway

        if (!$gateway) {
            return redirect()->back()->with('error', 'No active payment gateway found.');
        }

        $type = $gateway->type; // Access the 'type' property
        $payments = collect(); // Initialize $payments to avoid "undefined variable" errors
        $userId = auth()->id(); // Get the authenticated user's ID

        if ($type == 'uddoktapay') {
            $query = Uddoktapay::where('user_id', $userId); // Filter by authenticated user

            if ($request->key) {
                $query->where('invoice_id', 'like', '%' . $request->key . '%');
            }

            if ($request->from && $request->to) {
                $query->whereBetween('created_at', [$request->from, $request->to]);
            }

            $payments = $query->orderBy('id', 'desc')->paginate(15);
        }

        if ($type == 'greenpaybd') {
            $query = Payment::where('user_id', $userId); // Filter by authenticated user

            if ($request->key) {
                $query->where('transaction_id', 'like', '%' . $request->key . '%');
            }

            if ($request->from && $request->to) {
                $query->whereBetween('created_at', [$request->from, $request->to]);
            }

            $payments = $query->orderBy('id', 'desc')->paginate(15);
        }

        return view('user.transactions', compact('payments', 'type'));
    }

    public function update(Request $request)
    {
        if ($request->updatePassword != null) {
            // Validate the request data
            $request->validate([
                'current_password' => ['required', 'string'],
                'password' => ['required', 'string', 'min:8'],
            ]);

            // Check if the current password matches the user's password
            if (!Hash::check($request->current_password, auth()->user()->password)) {
                return back()->withErrors(['current_password' => 'Your current password is incorrect']);
            }
            if ($request->password != $request->password_confirmation) {
                return redirect()->back()->with('error', 'Password confirmation not match!');
            }

            // Update the user's password
            $user = auth()->user();
            $user->password = Hash::make($request->password);
            $user->save();

            // Return a success message
            return redirect()->back()->with('success', 'Password updated successfully!');
        }

        if ($request->profile != null) {
            $user = Auth::user();

            // Validate the email and phone with unique constraint
            $request->validate([
                'email' => 'required|email|unique:users,email,' . $user->id, // Unique except for the current user
                'phone' => 'required|unique:users,phone,' . $user->id, // Unique except for the current user
            ]);

            // Update user's email and phone
            $user->email = $request->input('email');
            $user->phone = $request->input('phone');
            $user->save();

            return redirect()->back()->with('success', 'Profile updated successfully.');
        }
    } // End Method
}
