@extends('frontend.master')
@section('content')

<div class="container mt-4">
    <h2 class="text-center mb-4">🏆 Monthly Leaderboard - Top 10 Users 🏆</h2>

    <div class="card shadow">
        <div class="card-body">
            <table class="table table-bordered table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>User</th>
                        <th>Total Completed Orders</th>
                        <th>Gift Waiting for You 🎁</th> <!-- New Column -->
                    </tr>
                </thead>
                <tbody>
                    @forelse ($topUsers as $index => $user)
                        <tr>
                            <td class="fw-bold">{{ $index + 1 }}</td>
                            <td>{{ $user->name }}</td>
                            <td class="text-success fw-bold">{{ $user->total_orders }}</td>
                            <td class="text-center">
                                <a href="https://whatsapp.com/channel/0029VaWmZqo2ER6mtvpnkL2Z" target="_blank" class="btn btn-danger btn-sm">
                                    ❤️ Claim Now!
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center text-muted">No completed orders this month.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection
