@extends('frontend.master')
@section('content')
    <div class="container-fluid">
        <div class="cover_div">
            <div class="cover_div_overlay"></div>
        </div>
        <div class="ap_placement container">
            <div class="col-sm-9 mx-auto">
                <table>
                    <tbody>
                        <tr>
                            <td>
                                <span
                                    class="account_profile_icon">{{ strtoupper(substr(Auth::user()->name, 0, 1)) }}</span>
                            </td>
                            <td>
                                <div class="acc_username">{{ Auth::user()->name }}
<body>
    <svg class="verify-icon" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-label="Verify Icon">
        <path d="M23 12l-2.44-2.79.34-3.69-3.61-.82-1.89-3.2L12 2.96 8.6 1.5 6.71 4.69 3.1 5.5l.34 3.7L1 12l2.44 2.79-.34 3.7 3.61.82L8.6 22.5l3.4-1.47 3.4 1.46 1.89-3.19 3.61-.82-.34-3.69L23 12zm-12.91 4.72l-3.8-3.81 1.48-1.48 2.32 2.33 5.85-5.87 1.48 1.48-7.33 7.35z"></path>
    </svg><style>
        .verify-icon {
            width: 20px;
            height: 20px;
            fill: #1728e4;
        }
    </style></div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="container" align="center">
        <div class="acc_infos col-sm-9 mx-auto">
            <div class="row">
                <div class="col-4">
                    <div class="acc_info_box">
                        <div class="heading">ব্যালেন্স</div>
                        ৳{{ Auth::user()->balance }}
                    </div>
                </div>
                <div class="col-4">
                    <div class="acc_info_box">
                        <div class="heading">মোট অর্ডার</div>
                        {{ $orders }}
                    </div>
                </div>
                <div class="col-4">
                    <div class="acc_info_box">
                        <div class="heading">মোট খরচ হয়েছে</div>
                        ৳ {{ number_format($totalSpend, 2) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">

        <div class="p-tb-20">
            <div class="panel simple_form shadow col-sm-9 mx-auto">
                <div class="panel_head">
                    <div class="title">
                        ব্যক্তিগত তথ্য
                    </div>
                </div>
                <div class="body">
                    <form method="POST" action="{{ url('user/update') }}">
                        @csrf
                        <div>
                            <label for="email" class="control-label">ইমেইল</label>
                            <input type="text" class="form-control shadow" name="email"
                                value="{{ Auth::user()->email }}" required="">
                            @error('email')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>



                        <div>
                            <label for="phone" class="control-label">ফোন নম্বর</label>
                            <input type="text" class="form-control shadow" name="phone"
                                value="{{ Auth::user()->phone }}" required="">
                            @error('phone')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="clearfix" align="center">
                            <input type="submit" class="btn theme-btn-block shadow" name="profile" value="আপডেট">
                        </div>
                    </form>
                </div>
            </div>
            <div class="panel simple_form shadow col-sm-9 mx-auto">
                <div class="panel_head">
                    <div class="title">
                        পাসওয়ার্ড পরিবর্তন করুন
                    </div>
                </div>
                <div class="body">
                    <form method="POST" action="{{ url('user/update') }}">
                        @csrf

                        <div>
                            <label class="control-label">বর্তমান পাসওয়ার্ড</label>
                            <input type="password" class="form-control shadow" name="current_password" required="">
                            @error('current_password')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>


                        <div>
                            <label class="control-label">নতুন পাসওয়ার্ড</label>
                            <input type="password" class="form-control shadow" name="password" required="">
                            @error('password')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>


                        <div>
                            <label class="control-label">নতুন পাসওয়ার্ড নিশ্চিত করুন</label>
                            <input type="password" class="form-control shadow" name="password_confirmation"
                                required="">
                            @error('password_confirmation')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>


                        <div class="clearfix" align="center">
                            <input type="submit" name="updatePassword" class="btn theme-btn-block shadow"
                                value="আপডেট">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
  
       


    @php
$menus = App\Models\Menu::all();
@endphp
    <div class="sticky-footer-container">
        @foreach ($menus as $menu)
            <div class="sticky-footer-item">
                <a href="{{ $menu->link }}">
                    <div class="d-flex justify-content-center align-items-center flex-column">
                        <span>{!! $menu->icon !!}</span> 
                        <span>{{ $menu->name }}</span>
                    </div>
                </a>
            </div>
        @endforeach
    </div>

@endsection


@section('js')
    <script src="{{ url('/') . '/public/assets/frontend/assets/' }}template/js/jquery-3.7.1.min.js"></script>


    <script src="{{ url('/') . '/public/assets/frontend/assets/' }}template/js/bootstrap/bootstrap.bundle.min.js"></script>


    <script src="{{ url('/') . '/public/assets/frontend/assets/' }}template/js/toastr/toastr.min.js"></script>


    @if (session()->has('error'))
        <script>
            window.onload = function() {
                alert("{{ session('error') }}");
            };
        </script>
    @endif
    @if (session()->has('success'))
        <script>
            window.onload = function() {
                alert("{{ session('success') }}");
            };
        </script>
    @endif


    <script>
        $(document).ready(function() {
            $('#accountButton').click(function() {
                $('.right-side-menu').toggleClass('active');
                $('#overlay').toggle();
            });

            $('#closeButton').click(function() {
                $('.right-side-menu').removeClass('active');
                $('#overlay').hide();
            });

            $('#overlay').click(function() {
                $('.right-side-menu').removeClass('active');
                $('#overlay').hide();
            });
        });
    </script>

  
@endsection
