@extends('frontend.master')
@section('content')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<div class="container-fluid">
    <div class="col-sm-9 mx-auto p-tb-20">
        <center>
            <a href="https://shop.garena.my/app/100067/idlogin" target="_blank">
                <button type="button" class="btn btn-aght theme-btn-block">REDEEM CODE</button>
            </a>
        </center>
        <div class="p-tb-20">
            <form method="get" style="display: flex; align-items: center; width: 100%;">
                <div style="display: flex; align-items: center; width: 100%;">
                    <select name="status" id="status" class="searchstatus clickable-status">
                        <option value="" selected="">ALL</option>
                        <option value="completed">COMPLETED</option>
                        <option value="processing">PROCESSING</option>
                        <option value="auto-processing">AUTO-PROCESSING</option>
                        <option value="hold">HOLD</option>
                        <option value="pending">PENDING</option>
                        <option value="cancelled">CANCELLED</option>
                    </select>
                    <input type="text" name="title" value="" class="searchbox shadow" placeholder="Search orders...">
                </div>
                <button type="submit" class="btn theme-btn shadow" style="height: 40px;">Search</button>
            </form>
        </div>
        <div class="content-box-no-padding shadow" style="margin: 0px;padding: 0px;">
            <div class="content-title-ms">My Orders</div>
            <table class="content-box-no-padding-table table table-striped table-mobile-responsive table-mobile-sided fully-responsive-table" style="margin: 0px;" width="100%">
                <thead>
                    <tr class="align-middle">
                        <th scope="col" style="border-radius: 12px 0px 0px 0px !important;">Id</th>
                        <th scope="col">Date</th>
                        <th scope="col">Product</th>
                        <th scope="col">Package</th>
                        <th scope="col">Price</th>
                        <th scope="col">Payment Type</th>
                        <th scope="col">Voucher</th>
                        <th scope="col" style="border-radius: 0px 12px 0px 0px !important; padding-right: 10px;">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($orders as $order)
                        @php
                            $product = App\Models\Product::find($order->product_id);
                            $variation = App\Models\Variation::find($order->variation_id);
                            // OrderItem থেকে ভাউচার আইডি লিস্ট নিয়ে আসা
                            $orderItems = $order->items;
                            $allVoucherIds = [];
                            $allVoucherCodes = [];
                            foreach ($orderItems as $item) {
                                if ($item->voucher_ids) {
                                    $voucherIds = json_decode($item->voucher_ids, true);
                                    if (is_array($voucherIds)) {
                                        $allVoucherIds = array_merge($allVoucherIds, $voucherIds);
                                        foreach ($voucherIds as $voucherId) {
                                            $voucher = App\Models\Voucher::find($voucherId);
                                            if ($voucher) {
                                                $modifiedCode = $voucher->code;
                                                $prefixesToRemove = ['BDMB-', 'UPBD-'];
                                                foreach ($prefixesToRemove as $prefix) {
                                                    if (str_starts_with($modifiedCode, $prefix)) {
                                                        $modifiedCode = str_replace($prefix, '', $modifiedCode);
                                                        break;
                                                    }
                                                }
                                                $allVoucherCodes[] = $modifiedCode;
                                            }
                                        }
                                    }
                                }
                            }
                            // সব কোড একসাথে জমা করা (লাইন বাই লাইন কপির জন্য)
                            $copyText = implode("\n", $allVoucherCodes);
                        @endphp
                        <tr class="info_list align-middle" id="refresh_{{ $order->id }}">
                            <td scope="row" data-content="Id">{{ $order->id }}</td>
                            <td data-content="Date">{{ $order->created_at->format('d-m-Y') }}</td>
                            <td data-content="Product">{{ $product->title ?? '' }}</td>
                            <td data-content="Package">{{ $variation->title ?? '' }}</td>
                            <td data-content="Price">৳{{ number_format($order->total_price, 2) ?? '' }}</td>
                            <td>{{ $order->payment_type ?? 'Not Found' }}</td>
                            <td>
                                @if ($order->type == 'voucher' && $order->status == '2')
                                    @if (!empty($allVoucherIds))
                                        <div style="margin-bottom: 5px;">
                                            @foreach ($allVoucherIds as $index => $voucherId)
                                                @php
                                                    $voucher = App\Models\Voucher::find($voucherId);
                                                @endphp
                                                @if ($voucher)
                                                    <div style="margin-bottom: 5px;">
                                                        <span class="voucher-code">{{ $voucher->code }}</span>
                                                    </div>
                                                @endif
                                            @endforeach
                                            <button type="button" class="btn theme-btn vouchercopy" data-voucher="{{ $copyText }}">Copy</button>
                                        </div>
                                    @else
                                        No vouchers available
                                    @endif
                                @else
                                    N/A
                                @endif
                            </td>
                            <td data-content="Status" class="pay-now">
                                <div class="text-danger">
                                    @switch($order->status)
                                        @case('0')
                                            PENDING
                                            @break
                                        @case('1')
                                            PROCESSING
                                            @break
                                        @case('2')
                                            COMPLETED
                                            @break
                                        @case('3')
                                            CANCELLED
                                            @break
                                    @endswitch
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $orders->links() }}
        </div>
    </div>
</div>

@php
$menus = App\Models\Menu::all();
@endphp

<div class="sticky-footer-container">
    @foreach ($menus as $menu)
        <div class="sticky-footer-item">
            <a href="{{ $menu->link }}">
                <div class="d-flex justify-content-center align-items-center flex-column">
                    <span>{!! $menu->icon !!}</span> 
                    <span>{{ $menu->name }}</span>
                </div>
            </a>
        </div>
    @endforeach
</div>

<script>
    $(document).ready(function() {
        $('.vouchercopy').on('click', function() {
            var voucherCodes = $(this).data('voucher');
            navigator.clipboard.writeText(voucherCodes).then(function() {
                alert('Voucher codes copied to clipboard:\n' + voucherCodes);
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        });
    });
</script>

@endsection