@extends('frontend.master')
@section('content')
    @php

        // Get Bkash Merchant Enable Status
        $bkashEnabled = App\Models\Setting::where('key', 'bkash_merchant_enable')->value('value');

        // Get all active payment gateways
        $paymentGateways = App\Models\PaymentGateway::where('is_active', '1')->get();
    @endphp
    <div class="container-fluid">
        <div class="col-sm-9 mx-auto p-tb-20">
            <div class="panel simple_form shadow m-tb-20">
                <div class="panel_head">
                    <div class="title">
                        <h4 class="mb-0">💰 Add Fund</h4>
                    </div>
                </div>


                <div class="card-body">
                    <form method="POST" action="{{ route('url-create') }}" id="paymentForm">
                        @csrf

                        <!-- Dropdown for Payment Method -->
                        <div class="mb-3">
                            <label for="paymentMethod" class="form-label fw-bold">Select Payment Method:</label>
                            <select id="paymentMethod" name="payment_method" class="form-select" required>
                                <option value="" selected disabled>Choose Payment Method</option>

                                <!-- Show Bkash Merchant if Enabled -->
                                @if ($bkashEnabled == '1')
                                    <option value="bkash"">
                                       Bkash Merchant
                                    </option>
                                @else
                                    <option value="" disabled> No Bkash Merchant Available</option>
                                @endif
                                <option value="gateway">Payment Gateway</option>

                            </select>
                        </div>

                        <!-- Amount Input -->
                        <div class="mb-3">
                            <label for="amount" class="form-label fw-bold">Enter Amount:</label>
                            <input type="number" name="amount" id="amount" class="form-control"
                                placeholder="Enter Amount" min="1" max="10000" required>
                        </div>

                        <!-- Pay Now Button -->
                        <div class="d-grid">
                            <button type="submit" class="btn btn-aght theme-btn-block">
                                <i class="fas fa-wallet"></i> Pay Now
                            </button>
                        </div>
                    </form>
                </div>

            </div>

        </div>
    </div>


    @php
        $menus = App\Models\Menu::all();
    @endphp



    <div class="sticky-footer-container">
        @foreach ($menus as $menu)
            <div class="sticky-footer-item">
                <a href="{{ $menu->link }}">
                    <div class="d-flex justify-content-center align-items-center flex-column">
                        <span>{!! $menu->icon !!}</span>
                        <span>{{ $menu->name }}</span>
                    </div>
                </a>
            </div>
        @endforeach
    </div>



    </div>

    <!-- Correcting Form Action Dynamically -->
    <script>
        document.getElementById("paymentMethod").addEventListener("change", function() {
            let form = document.getElementById("paymentForm");
            let selectedMethod = this.value;

            if (selectedMethod === "gateway") {
                form.action = "{{ route('processPayment') }}";
            } else {
                form.action = "{{ route('url-create') }}";
            }
        });
    </script>
@endsection
