<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Your Password</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            color: #333;
        }
        .email-container {
            max-width: 600px;
            margin: 50px auto;
            background-color: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        .email-header {
            background-color: #4caf50;
            color: #fff;
            padding: 20px;
            text-align: center;
        }
        .email-body {
            padding: 20px;
        }
        .email-body h1 {
            margin-top: 0;
            color: #4caf50;
        }
        .email-body p {
            line-height: 1.6;
        }
        .reset-button {
            display: inline-block;
            margin: 20px 0;
            padding: 10px 20px;
            background-color: #4caf50;
            color: #fff;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
        }
        .reset-button:hover {
            background-color: #43a047;
        }
        .email-footer {
            text-align: center;
            padding: 20px;
            background-color: #f4f4f4;
            color: #999;
            font-size: 12px;
        }
        .email-footer a {
            color: #4caf50;
            text-decoration: none;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="email-header">
            <h1>Reset Your Password</h1>
        </div>
        <div class="email-body">
            <p>Hi,</p>
            <p>We received a request to reset your password. You can reset your password by clicking the button below:</p>
            <a href="{{ route('reset.password.get', $token) }}" class="reset-button">Reset Password</a>
            <p>If the button above doesn't work, copy and paste the following link into your web browser:</p>
            <p><a href="{{ route('reset.password.get', $token) }}">{{ route('reset.password.get', $token) }}</a></p>
            <p>If you didn't request a password reset, you can safely ignore this email.</p>
            <p>Thank you,<br>Rex GamingBD Topup Shop</p>
        </div>
        <div class="email-footer">
            <p>© {{ date('Y') }} Rex GamingBD Topup Shop. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
