@extends('frontend.master')

@section('content')
<div class="container-fluid">
    <div class="row">


        @env('local')
        <div class="mb-3 d-flex justify-content-center gap-3">
            <x-login-link label="Quick Login as Admin"
                email="admin@gmail.com" 
                class="btn btn-primary text-uppercase fw-semibold text-white"
            >
            </x-login-link>
            
            <x-login-link label="Quick Login as User"
                email="user@gmail.com" 
                class="btn btn-success text-uppercase fw-semibold text-white"
            >
            </x-login-link>
        </div>
        
        <div class="mb-3 text-muted text-center">
            - OR -
        </div>
        @endenv
        <!-- Sidebar Image Section -->
        <div class="col-md-4 d-none d-md-block"> <!-- This will be hidden on small screens and displayed on medium and larger screens -->
            <img src="public/login.png" alt="Login Sidebar Image" class="img-fluid">
        </div>

       
        
        <!-- Login Form Section -->
        <div class="col-12 col-sm-12 col-md-6 col-lg-6 mx-auto my-4">
            <div class="content-box shadow p-4">
                <h2 class="login-title mb-4">Login</h2>

                <!-- Google Login -->
                <a class="btn btn-danger btn-google w-100 mb-3" href="{{ url('auth/google') }}">
                    Login with Google
                </a>

                <div class="sign_separator mb-4">
                    <hr class="line"> Or sign in <hr class="line">
                </div>

                <!-- Display Success and Error Messages -->
                <div>
                    @if (session()->has('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if (session()->has('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                </div>

                <!-- Login Form -->
                <form method="POST" action="{{ url('login') }}">
                    @csrf
                   
<div class="form-group form-group-icon mb-3">
    <label class="control-label" for="login">
        <i class="fas fa-envelope"></i>
    </label>
    <input type="text" class="form-control" name="email" placeholder="Email">
    @error('email')
        <span style="color: red;">
            <strong>{{ $message }}</strong>
        </span>
    @enderror
</div>

<div class="form-group form-group-icon mb-3">
    <label class="control-label" for="password">
        <i class="fas fa-lock"></i>
    </label>
    <input type="password" class="form-control" name="password" placeholder="Password" autocomplete="off">
    @error('password')
        <span style="color: red;">
            <strong>{{ $message }}</strong>
        </span>
    @enderror
</div>


                    <div class="form-group mb-3">
                        <div class="form-group__checkbox">
                            <label class="form-group__checkbox-label">
                                <input type="checkbox" name="remember" value="1">
                                <span class="checkmark"></span>
                            </label>
                            <label class="form-group__label-title" for="terms" style="display: inline;">Remember me</label>
                        </div>
                    </div>

                    <div class="component_button_submit">
                        <button type="submit" name="signin" class="btn btn-light theme-btn-block w-100">LOGIN</button>
                    </div>

                    <div class="text-center mt-3">
                        <a href="{{ route('forget.password.get') }}">Forget Password?</a>
                    </div>

                    <div class="text-center mt-3">
                        Don't have an account? <a href="/register">Register</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

   
</div>

@php
$menus = App\Models\Menu::all();
@endphp

<div class="sticky-footer-container">
    @foreach ($menus as $menu)
        <div class="sticky-footer-item">
            <a href="{{ $menu->link }}">
                <div class="d-flex justify-content-center align-items-center flex-column">
                    <span>{!! $menu->icon !!}</span> 
                    <span>{{ $menu->name }}</span>
                </div>
            </a>
        </div>
    @endforeach
</div>

<script>
    $(document).ready(function() {
        $('#accountButton').click(function() {
            $('.right-side-menu').toggleClass('active');
            $('#overlay').toggle();
        });

        $('#closeButton').click(function() {
            $('.right-side-menu').removeClass('active');
            $('#overlay').hide();
        });

        $('#overlay').click(function() {
            $('.right-side-menu').removeClass('active');
            $('#overlay').hide();
        });
    });
</script>

@endsection
