@extends('admin.admin_dashboard')
@section('admin')
    <div class="page-content">

        <!-- Page Heading -->
        <h1 class="h3 mb-2 text-gray-800">VARIATION LIST</h1>

        <!-- DataTales Example -->
        <div class="card shadow mb-1">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger mb-1">
                    {{ session('error') }}
                </div>
            @endif


            <!-- Begin Page Content -->
            <div class="container-fluid">
                <div class="card-body">

                    <br>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($variations as $variation)
                                    <tr>
                                        <td>{{ $variation->title }}</td>
                                        <td>{{ $variation->price }}</td>
                                        <td>{{ $variation->stock }}</td>
                                        <td>
                                            @if (isset($variation->automatic))
                                                Automatic
                                            @endif
                                            @if (!isset($variation->automatic))
                                                Manual
                                            @endif
                                        </td>
                                        <td>
                                            <a onclick="return confirm('Are you sure to delete ?')"
                                                href="{{ url('admin/variation/delete', $variation->id) }}"
                                                class="btn btn-danger btn-circle">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                            <a href="{{ url('admin/variation/edit', $variation->id) }}"
                                                class="btn btn-success btn-circle">
                                                <i class="fas fa-pen"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                        {{ $variations->links() }}

                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection
