@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">


        <!-- Page Heading -->
        <h1 class="h3 mb-2 text-gray-800">UPDATE VARIATION</h1>

        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif


            <!-- Begin Page Content -->
            <div class="container-fluid">
                <div class="card-body">
                    <form action="{{ url('admin/variation/update', $variation->id) }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label>Title</label>
                                <input type="text" name="title" class="form-control"
                                value="{{ $variation->title }}" placeholder="Enter title"/>
                                @error('title')
                                    <span style="color: red;">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>


                            <div class="form-group col-md-12">
                                <label>Price</label>
                                <input type="integer" name="price" class="form-control"
                                value="{{ $variation->price }}" placeholder="Enter price"/>
                                @error('price')
                                    <span style="color: red;">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>


                            <div class="form-group col-md-12">
                                <label>Stock</label>
                                <input type="integer" name="stock" class="form-control"
                                value="{{ $variation->stock }}" placeholder="Enter stock"/>
                                @error('stock')
                                    <span style="color: red;">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <input type="hidden" name="id" value="{{ $id }}">
                        <button type="submit" class="btn btn-primary">UPDATE</button>
                        <a href="{{ url('admin/product/'.$variation->product_id.'/edit') }}" class="btn btn-success">BACK</a>
                    </form>



                </div>
            </div>

        </div>

    </div>
@endsection


@section('js')
    <!-- Bootstrap core JavaScript-->
    <script>
        $(document).ready(function() {
            // Function to update character count
            function updateCharCount(element, countElement, maxLength) {
                var count = element.val().length;
                countElement.text(count + '/' + maxLength);
            }

            // Character count for Title
            $('#title').keyup(function() {
                updateCharCount($(this), $('#titleCount'), 100);
            });

            // Character count for Search Keywords
            $('#searchKeyword').keyup(function() {
                updateCharCount($(this), $('#searchKeywordCount'), 200);
            });

            // Character count for Meta Description
            $('#metaDescription').keyup(function() {
                updateCharCount($(this), $('#metaDescriptionCount'), 250);
            });

            // Character count for Post Description
            $('#editor1').keyup(function() {
                updateCharCount($(this), $('#detailsCount'), 500);
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#imageInput').on('change', function() {
                var input = this;
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#selectedImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            });
        });
    </script>

    <script src="{{ url('/') }}/public/assets/backend/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{ url('/') }}/public/assets/backend/js/sb-admin-2.min.js"></script>

    <script src="{{ url('/') }}/public/assets/editor/ckeditor/ckeditor.js"></script>
    <script src="{{ url('/') }}/public/assets/editor/ckeditor/adapters/jquery.js"></script>
    <script src="{{ url('/') }}/public/assets/editor/ckeditor/styles.js"></script>
    <script src="{{ url('/') }}/public/assets/editor/ckeditor/ckeditor.custom.js"></script>
@endsection
