@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">
    <h1 class="h3 mb-2 text-gray-800">ADD VARIATION</h1>

    <div class="card shadow mb-4">
        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session()->has('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <div class="container-fluid">
            <div class="card-body">
                <form action="{{ url('admin/variation/store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-row">
                        <!-- Title Input -->
                        <div class="form-group col-md-12">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control" value="{{ old('title') }}" placeholder="Enter title"/>
                            @error('title')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <!-- Price Input -->
                        <div class="form-group col-md-12">
                            <label>Price</label>
                            <input type="integer" name="price" class="form-control" value="{{ old('price') }}" placeholder="Enter price"/>
                            @error('price')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <!-- Stock Input -->
                        <div class="form-group col-md-12">
                            <label>Stock</label>
                            <input type="integer" name="stock" class="form-control" value="{{ old('stock') }}" placeholder="Enter stock"/>
                            @error('stock')
                                <span style="color: red;">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <!-- Checkbox for Select Option -->
                        <div class="form-group col-md-12">
                            <label>
                                <input type="checkbox" id="variationCheckbox"> Enable Additional Options
                            </label>
                        </div>

                        <!-- Select Box (Initially Hidden) -->
                        <div class="form-group col-md-12" id="variationSelectBox" style="display: none;">
                            <label>Select Variation</label>
                            <select name="automatic" class="form-control">
                                <option value="">Select an option</option>
                                @foreach ($vseeds as $key=>$vseed)
                                <option value="{{ $vseed->name }}">{{ $vseed->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <input type="hidden" name="id" value="{{ $id }}">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('variationCheckbox').addEventListener('change', function() {
        var selectBox = document.getElementById('variationSelectBox');
        selectBox.style.display = this.checked ? 'block' : 'none';
    });
</script>

@endsection
