@extends('admin.admin_dashboard')
@section('admin')
    <div class="page-content">
        <h1 class="h3 mb-2 text-gray-800">Payment List <span class="badge bg-danger rounded-pill modern-badge">{{ count($payments) }}</span></h1>

        <!-- Alert Messages -->
        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session()->has('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <!-- Filter Form -->
        <form action="{{ url('/admin/transaction') }}" method="get">
            @csrf
            <div class="row align-items-center">
                <div class="col-md-4 mb-3">
                    <input type="text" class="form-control" name="key" placeholder="Search by entry number">
                </div>
                <div class="col-md-4 mb-3">

                    <input type="date" class="form-control" name="from" value="{{ request('from') }}">

                </div>
                <div class="col-md-4 mb-3">
                    <input type="date" class="form-control" name="to" value="{{ request('to') }}">
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn btn-primary btn-sm">Search</button>
                </div>
            </div>
        </form>

        <!-- Orders Table -->
        <div class="table-responsive mt-4">
            <table class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr class="align-middle">
                        <th>ID</th>
                        <th>User Name</th>
                        <th scope="col" style="border-radius: 12px 0px 0px 0px !important; text-align: center;">
                            Date
                        </th>

                        <th scope="col">Amount</th>
                        <th scope="col">Payment Method</th>
                        <th scope="col">Transaction ID</th>
                        <th scope="col" style="border-radius: 0px 15px 0px 0px !important; text-align: center;">
                            Status
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($payments as $payment)
                        <tr>
                            <td>{{ $payment->id }}</td>
                            <td>
                                
                                <a href="{{ route('admin.users.wallet-history', $payment->user->id ?? 0) }}">
                                    {{ $payment->user->name ?? 'N/A' }}
                                </a>
                            
                            
                            </td>
                            <td>{{ $payment->created_at->format('d M y, h:i A') }}</td>
                            <td>{{ $payment->amount }}</td>
                            <td>{{ 'Payment Getway' }}</td>
                            <td>{{ $payment->transaction_id }}</td>





                            <td>
                                @if ($payment->payment_status == 'pending')
                                    <button class="btn btn-warning">Pending</button>
                                @elseif($payment->payment_status == 'completed')
                                    <button class="btn btn-success">Complete</button>
                                @else
                                    <p>Status Unknown</p>
                                @endif
                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>

            {{ $payments->links() }}

        </div>
    </div>
    </div>

    </div>

    </div>
@endsection


@section('js')
    <!-- Bootstrap core JavaScript-->
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery/jquery.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{ url('/') }}/public/assets/backend/js/sb-admin-2.min.js"></script>

    <!-- Page level plugins -->
    <script src="{{ url('/') }}/public/assets/backend/vendor/chart.js/Chart.min.js"></script>

    <!-- Page level custom scripts -->
    <script src="{{ url('/') }}/public/assets/backend/js/demo/chart-area-demo.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/js/demo/chart-pie-demo.js"></script>
@endsection
