@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">
        <h1 class="h3 mb-4 text-gray-800">Sliders</h1>
        
        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        
        <a href="{{ route('sliders.create') }}" class="btn btn-primary mb-3">Add Slider</a>
        
        <table class="table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Image</th>
                    <th>Image URL</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($sliders as $slider)
                    <tr>
                        <td>{{ $slider->id }}</td>

                        <td>{{ $slider->link }}</td>
                        <td>
                            <img src="{{ asset('tipu/rexgamingbd2/'.$slider->image_url) }}" alt="Slider Image" style="width: 200px; height: 80px;" >
                        
                        </td>
                       
                        <td>
                            <a href="{{ route('sliders.edit', $slider) }}" class="btn btn-warning">Edit</a>
                            <form action="{{ route('sliders.destroy', $slider) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection
