@extends('admin.admin_dashboard')
@section('admin')

    <div class="page-content">
        <h1 class="h3 mb-4 text-gray-800">Site Settings</h1>

        <!-- Success & Error Messages -->
        @if (session()->has('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- Settings Form -->
        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">General Settings</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.setting.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <!-- SEO Setup -->
                    <h5 class="mt-4 text-primary">SEO Setup</h5>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="site_title">Site Title</label>
                            <input type="text" class="form-control" id="site_title" name="site_title"
                                value="{{ old('site_title', $settings['site_title'] ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label for="meta_description">Meta Description</label>
                            <input type="text" class="form-control" id="meta_description" name="meta_description"
                                value="{{ old('meta_description', $settings['meta_description'] ?? '') }}">
                        </div>
                        <div class="col-md-4 mt-3">
                            <label for="meta_keywords">Meta Keywords</label>
                            <input type="text" class="form-control" id="meta_keywords" name="meta_keywords"
                                value="{{ old('meta_keywords', $settings['meta_keywords'] ?? '') }}">
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-md-4">

                            <!-- Support Information -->
                            <h5 class="mt-4 text-primary">Support Information</h5>
                            <label for="support_phone">Support Phone</label>
                            <input type="text" class="form-control" id="support_phone" name="support_phone"
                                value="{{ old('support_phone', $settings['support_phone'] ?? '') }}">
                        </div>

                        <div class="col-md-4">
                            <!-- Stay Connected -->
                            <h5 class="mt-4 text-primary">Stay Connected</h5>
                            <label for="footer_email">Footer Email</label>
                            <input type="email" class="form-control" id="footer_email" name="footer_email"
                                value="{{ old('footer_email', $settings['footer_email'] ?? '') }}">
                        </div>
                        <div class="col-md-4">

                            <label for="footer_copyright" class="mt-3">Footer Copyright</label>
                            <textarea class="form-control" id="footer_copyright" name="footer_copyright" rows="2">{{ old('footer_copyright', $settings['footer_copyright'] ?? '') }}</textarea>

                        </div>


                    </div>




                    <!-- Social Media Links -->
                    <h5 class="mt-4 text-primary">Social Media Links</h5>
                    <div class="row">
                        <div class="col-md-6">
                            <label for="facebook_url">Facebook URL</label>
                            <input type="url" class="form-control" id="facebook_url" name="facebook_url"
                                value="{{ old('facebook_url', $settings['facebook_url'] ?? '') }}">
                        </div>
                        <div class="col-md-6">
                            <label for="messenger_url">Messenger URL</label>
                            <input type="url" class="form-control" id="messenger_url" name="messenger_url"
                                value="{{ old('messenger_url', $settings['messenger_url'] ?? '') }}">
                        </div>
                        <div class="col-md-6 mt-3">
                            <label for="youtube_url">YouTube URL</label>
                            <input type="url" class="form-control" id="youtube_url" name="youtube_url"
                                value="{{ old('youtube_url', $settings['youtube_url'] ?? '') }}">
                        </div>

                        <div class="col-md-6 mt-3">
                            <label for="auto_remove_order">Auto Remove Pending Order In Minutes (default: 5)</label>
                            <input type="text" class="form-control" id="auto_remove_order" name="auto_remove_order"
                                value="{{ old('auto_remove_order', $settings['auto_remove_order'] ?? '') }}">
                        </div>




                    </div>

                    <!-- Api -->
                    <h5 class="mt-4 text-primary">Api</h5>
                    <div class="row">

                        <div class="col-md-6 mt-3">
                            <label for="auto_api_url">Auto TopUp API URL</label>
                            <input type="url" class="form-control @error('auto_api_url') is-invalid @enderror"
                                id="auto_api_url" name="auto_api_url"
                                value="{{ old('auto_api_url', $settings['auto_api_url'] ?? '') }}">
                            @error('auto_api_url')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>


                        <div class="col-md-6 mt-3">
                            <label for="youtube_video">Auto TopUp API Key</label>
                            <input type="text" class="form-control @error('auto_api_key') is-invalid @enderror"
                                id="auto_api_key" name="auto_api_key"
                                value="{{ old('auto_api_key', $settings['auto_api_key'] ?? '') }}">
                            @error('auto_api_key')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                    </div>



                    <!-- Notice -->
                    <h5 class="mt-4 text-primary">Notice</h5>
                    <textarea class="form-control" id="notice_board" name="notice_board" rows="3">{{ old('notice_board', $settings['notice_board'] ?? '') }}</textarea>


                    <!-- WhatsApp API Settings -->
                    <h5 class="mt-4 text-primary">WhatsApp API Settings <span class="text-info"><a
                                href="https://web.whatsapp.com/send?phone=8801716720487&text=ineedgametopup-site"
                                target="_blank">Buy Api?</a></span></h5>
                    <div class="row">
                        <div class="col-md-6 mt-3">
                            <label>Enable WhatsApp Message API</label>
                            <div>
                                <input type="radio" id="whatsapp_message_api_enabled_yes"
                                    name="whatsapp_message_api_enabled" value="1"
                                    {{ old('whatsapp_message_api_enabled', $settings['whatsapp_message_api_enabled'] ?? 0) == 1 ? 'checked' : '' }}>
                                <label for="whatsapp_message_api_enabled_yes">Yes</label>
                                <input type="radio" id="whatsapp_message_api_enabled_no"
                                    name="whatsapp_message_api_enabled" value="0"
                                    {{ old('whatsapp_message_api_enabled', $settings['whatsapp_message_api_enabled'] ?? 0) == 0 ? 'checked' : '' }}>
                                <label for="whatsapp_message_api_enabled_no">No</label>
                            </div>
                        </div>
                        <div class="col-md-6 mt-3">
                            <label for="whatsapp_message_api">WhatsApp API</label>
                            <input type="text" class="form-control" id="whatsapp_message_api"
                                name="whatsapp_message_api"
                                value="{{ old('whatsapp_message_api', $settings['whatsapp_message_api'] ?? '') }}">
                        </div>

                        <div class="col-md-6 mt-3">
                            <label for="whatsapp_admin_number">WhatsApp Admin</label>
                            <input type="text" class="form-control" id="whatsapp_admin_number"
                                name="whatsapp_admin_number"
                                value="{{ old('whatsapp_admin_number', $settings['whatsapp_admin_number'] ?? '') }}">
                        </div>
                        <div class="col-md-6 mt-3">
                            <label for="whatsapp_sender_number">WhatsApp Sender</label>
                            <input type="text" class="form-control" id="whatsapp_sender_number"
                                name="whatsapp_sender_number"
                                value="{{ old('whatsapp_sender_number', $settings['whatsapp_sender_number'] ?? '') }}">
                        </div>

                    </div>




                    <!-- Popup Text -->
                    <h5 class="mt-4 text-primary">Popup Text</h5>
                    <textarea class="form-control" id="PopupText" name="PopupText" rows="2">{{ old('PopupText', $settings['PopupText'] ?? '') }}</textarea>

                    <input type="radio" class="form-check-input" id="popup_enabled_true" name="popup_enabled"
                        value="true"
                        {{ old('popup_enabled', isset($settings['popup_enabled']) && $settings['popup_enabled'] == true ? 'checked' : '') }}>
                    <label class="form-check-label" for="popup_enabled_true">Yes</label>
                    <!-- Radio button for disabling the popup -->
                    <input type="radio" class="form-check-input" id="popup_enabled_false" name="popup_enabled"
                        value="false"
                        {{ old('popup_enabled', isset($settings['popup_enabled']) && !$settings['popup_enabled'] ? 'checked' : '') }}>
                    <label class="form-check-label" for="popup_enabled_false">No</label>






                    <!-- Chat Settings -->
                    <h5 class="mt-4 text-primary">Chat Settings</h5>
                    <label>Enable Chat</label>
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" id="chat_enabled_yes" name="chat_enabled"
                            value="1"
                            {{ old('chat_enabled', $settings['chat_enabled'] ?? 0) == 1 ? 'checked' : '' }}>
                        <label class="form-check-label" for="chat_enabled_yes">Yes</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" id="chat_enabled_no" name="chat_enabled"
                            value="0"
                            {{ old('chat_enabled', $settings['chat_enabled'] ?? 0) == 0 ? 'checked' : '' }}>
                        <label class="form-check-label" for="chat_enabled_no">No</label>
                    </div>
                    <br>
                    <label for="custom_js" class="mt-3">Chat Script</label>
                    <textarea class="form-control" id="custom_js" name="custom_js">{{ old('custom_js', $settings['custom_js'] ?? '') }}</textarea>

                    <!-- Facebook SEO Image -->
                    <h5 class="mt-4 text-primary">Facebook SEO Image</h5>
                    <input type="file" class="form-control mb-2" id="og_image" name="og_image">
                    <img src="{{ url('/' . $settings['og_image']) }}" alt="Facebook SEO Image"
                        style="max-width: 100px;">

                    <!-- Twitter SEO Image -->
                    <h5 class="mt-4 text-primary">Twitter SEO Image</h5>
                    <input type="file" class="form-control mb-2" id="twitter_image" name="twitter_image">
                    <img src="{{ url('/' . $settings['twitter_image']) }}" alt="Twitter SEO Image"
                        style="max-width: 100px;">

                    <!-- Favicon Upload -->
                    <h5 class="mt-4 text-primary">Favicon</h5>
                    <input type="file" class="form-control mb-2" id="favicon" name="favicon">
                    <img src="{{ url('/' . $settings['favicon']) }}" alt="Favicon" style="max-width: 100px;">

                    <!-- Logo Display and Upload -->
                    <h5 class="mt-4">Site Logo</h5>
                    <div class="form-group">

                        <img src="{{ url('/' . $settings['logo']) }}" alt="Site Logo" style="max-width: 200px;">
                        <br>
                        <input type="file" class="form-control @error('logo') is-invalid @enderror" id="logo"
                            name="logo">
                        @error('logo')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>


                    </br>



                    <!-- Submit Button -->
                    <div class="text-center mt-4">
                        <button type="submit" class="btn btn-primary btn-lg w-100">Save Settings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
