@extends('admin.admin_dashboard')

@section('admin')
    <div class="page-content">
        <h1 class="h3 mb-4 text-gray-800">Manage Payment Gateways</h1>

        <!-- Form for updating payment gateway statuses and API details -->
        <form action="{{ route('pay.gateways.update') }}" method="POST">
            @csrf

            <div class="row">
                @foreach($paymentGateways as $gateway)
                    <div class="col-md-4 mb-4">
                        <div class="card shadow {{ $gateway->is_active ? 'bg-success text-white' : '' }}">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-center">{{ $gateway->type }}</h6>
                            </div>
                            <div class="card-body">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" id="gateway_{{ $gateway->id }}" name="active_gateway" value="{{ $gateway->id }}" {{ $gateway->is_active ? 'checked' : '' }}>
                                    <label class="form-check-label" for="gateway_{{ $gateway->id }}">Set as Active</label>
                                </div>
                                <div class="form-group mt-2">
                                    <label for="api_key_{{ $gateway->id }}">API Key</label>
                                    <input type="text" class="form-control" id="api_key_{{ $gateway->id }}" name="api_key[{{ $gateway->id }}]" value="{{ $gateway->api_key }}">
                                </div>
                                <div class="form-group mt-2">
                                    <label for="client_{{ $gateway->id }}">Client</label>
                                    <input type="text" class="form-control" id="client_{{ $gateway->id }}" name="client[{{ $gateway->id }}]" value="{{ $gateway->client }}">
                                </div>
                                <div class="form-group mt-2">
                                    <label for="secret_{{ $gateway->id }}">Secret</label>
                                    <input type="text" class="form-control" id="secret_{{ $gateway->id }}" name="secret[{{ $gateway->id }}]" value="{{ $gateway->secret }}">
                                </div>
                                <div class="form-group mt-2">
                                    <label for="base_url_{{ $gateway->id }}">Base URL</label>
                                    <input type="text" class="form-control" id="base_url_{{ $gateway->id }}" name="base_url[{{ $gateway->id }}]" value="{{ $gateway->base_url }}">
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="d-flex justify-content-start mt-4">
                <button type="submit" class="btn btn-primary">Update Gateway</button>
            </div>
        </form>
    </div>
@endsection
