<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('pages')->insert([
            [
                'title' => 'About Us',
                'slug' => 'about-us',
                'content' => 'We are dedicated to providing the best gaming experience, focusing on quality, community, and customer support. Our team works tirelessly to ensure that every player feels valued and enjoys their time with us.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Contact Us',
                'slug' => 'contact-us',
                'content' => 'Feel free to reach out to us for any inquiries or support. We are here to help you have the best gaming experience possible.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'content' => 'Your privacy is important to us. We are committed to protecting your personal information and ensuring your gaming experience is safe.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Refund Policy',
                'slug' => 'refund-policy',
                'content' => 'If you are not satisfied with your purchase, please review our refund policy for more information.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'Terms and Conditions',
                'slug' => 'terms-and-conditions',
                'content' => 'Please review our terms and conditions to understand the rules and guidelines for using our platform.',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
