<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Orderitem extends Model
{
    use HasFactory;
// protected $guarded = [];

protected $fillable = ['order_id', 'variation_id', 'quantity', 'single_price', 'total_price', 'voucher_ids'];
protected $casts = ['voucher_ids' => 'array'];

public function order()
{
    return $this->belongsTo(Order::class);
}

public function variation()
{
    return $this->belongsTo(Variation::class);
}


}
