<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variation()
    {
        return $this->belongsTo(Variation::class, 'variation_id');
    }


    public function voucher()
    {
        return $this->belongsTo(Voucher::class, 'voucher_id');
    }


    public function payment()
    {
        return $this->hasOne(Payment::class);
    }

    public function autoTopup()
    {
        return $this->hasOne(AutoTopup::class, 'order_id');
    }

    public function items()
    {
        return $this->hasMany(Orderitem::class);
    }


  
}