<?php
namespace App\Http\Middleware;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\View;
use DB;

class RemoveOldOrders
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $autoRemoveMinutes = DB::table('settings')
            ->where('key', 'auto_remove_order')
            ->value('value');

        $autoRemoveMinutes = $autoRemoveMinutes ?? 30; // Default to 30 minutes if not set

        $cutoffTime = now()->subMinutes($autoRemoveMinutes);

        DB::table('orders')
            ->where('status', 0)
            ->where('created_at', '<', $cutoffTime)
            ->delete();

        return $next($request);
    }
}