<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function dashboard(){
        $data['orders'] = Order::where('user_id', Auth::user()->id)
            ->count();
        $data['totalSpend'] = Order::where('user_id', Auth::user()->id)
            ->where('status', '2')
            ->sum('total_price');
    
        return view('user.dashboard', $data);
    }


    public function message(){
        return view('user.message');
    }
}
