<?php

namespace App\Http\Controllers\admin;

use App\Models\Voucher;
use App\Models\Variation;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Crypt;

class VoucherController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->key != null || $request->from != null || $request->to != null) {
            $key = $request->key;
            $from = $request->from;
            $to = $request->to;

            $query = Voucher::query();
            if (isset($key)) {
                $query->where(function ($q) use ($key) {
                    $q->orWhere('code', 'like', '%' . $key . '%');
                });
            }
            if (isset($from) && isset($to)) {
                $query->where(function ($q) use ($from, $to) {
                    $q->WhereBetween('created_at', [$from, $to]);
                });
            }
            $vouchers = $query->paginate(15);
        } else {
            $vouchers = Voucher::orderBy('id', 'desc')->paginate(15);
        }
        // return $vouchers;
        return view('admin.voucher.voucher_list', compact('vouchers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.voucher.create_chose');
        // Fetch variations, excluding the one with product_id of 2

    }

    public function newCreate($value){

        if($value == 'automatic'){
            $variations = Variation::where('product_id', '!=', 10)
            ->where('automatic', '!=', null)
            ->orderBy('id', 'desc')
            ->get();
        }else{
            $variations = Variation::where('product_id', '!=', 10)
            ->where('automatic', null)
            ->orderBy('id', 'desc')
            ->get();
        }

        return view('admin.voucher.voucher_create', compact('variations'));
    }

    /**
     * Store a newly created resource in storage.
     */
    // public function store(Request $request)
    // {
    //     $this->validate($request, [
    //         'variation' => 'required',
    //         'code' => 'required',
    //     ]);

    //     $variation = Variation::find($request->variation);

    //     $voucher = new Voucher();
    //     $voucher->product_id = $variation->product_id;
    //     $voucher->variation = $request->variation;
    //     $voucher->price = $variation->price;
    //       // Encrypt the voucher code before saving it to the database
    // $voucher->code =($request->code);

    //     //$voucher->code = $request->code;
    //     $voucher->save();

    //     return redirect('admin/voucher')->with('success', 'Voucher created successfully');
    // }


    // public function store(Request $request) {
    //     // Validate the input
    //     $request->validate([
    //         'variation' => 'required|exists:variations,id', // Ensure the variation exists
    //         'code.*' => 'required|string' // Ensure all code fields are filled and are strings
    //     ]);
    
    //     // Find the variation based on the selected variation ID
    //     $variation = Variation::find($request->variation);
    
    //     // Loop through each entered code and create a new voucher for each
    //     foreach ($request->code as $code) {
    //         $voucher = new Voucher();
    //         $voucher->product_id = $variation->product_id;
    //         $voucher->variation = $request->variation;
    //         $voucher->price = $variation->price;
            
    //         // Encrypt the voucher code before saving it
    //         $voucher->code = encrypt($code);
    
    //         // Save the voucher
    //         $voucher->save();
    //     }
    
    //     // Redirect back with a success message
    //     return redirect('admin/voucher')->with('success', 'Voucher codes added successfully!');
    // }
    

    public function store(Request $request)
    {
        // Validate the input
        $request->validate([
            'variation' => 'required|exists:variations,id', // Ensure the variation exists
            'codes' => 'required|string' // Ensure the textarea is filled
        ]);
    
        // Find the selected variation
        $variation = Variation::find($request->variation);
    
        // Split the codes from the textarea into an array by new lines
        $codes = explode("\n", trim($request->codes));
    
        $duplicateCodes = []; // To store duplicate codes
        $addedCodes = []; // To store successfully added codes
    
        // Loop through each code and create a voucher for each
        foreach ($codes as $code) {
            $cleanCode = trim($code); // Remove any extra whitespace
            if (!empty($cleanCode)) {
                // Check if the code already exists in the database
                if (Voucher::where('code', $cleanCode)->exists()) {
                    $duplicateCodes[] = $cleanCode; // Add to duplicates
                } else {
                    // Create and save the new voucher
                    $voucher = new Voucher();
                    $voucher->product_id = $variation->product_id;
                    $voucher->variation = $request->variation;
                    $voucher->price = $variation->price;
                    $voucher->automatic = $variation->automatic; // Add automatic property
                    $voucher->code = $cleanCode;
                    $voucher->save();
    
                    $addedCodes[] = $cleanCode; // Add to successfully added codes
                }
            }
        }
    
        // Prepare the success and duplicate message
        $message = '';
        if (!empty($addedCodes)) {
            $message .= count($addedCodes) . " voucher(s) added successfully. ";
        }
        if (!empty($duplicateCodes)) {
            $message .= count($duplicateCodes) . " duplicate code(s) were skipped: " . implode(', ', $duplicateCodes) . ".";
        }
    
        // Redirect back with the appropriate message
        return redirect('admin/voucher')->with('success', $message);
    }
    
        
    

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $voucher = Voucher::find($id);
        $variations = Variation::orderBy('id', 'desc')->get();
        return view('admin.voucher.voucher_edit', compact('voucher', 'variations'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $this->validate($request, [
            'variation' => 'required',
            'code' => 'required',
        ]);

        $variation = Variation::find($request->variation);

        $voucher = Voucher::find($id);
        $voucher->product_id = $variation->product_id;
        $voucher->variation = $request->variation;
        $voucher->code = $request->code;
        $voucher->save();

        return redirect('admin/voucher')->with('success', 'Voucher updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function delete($id)
    {
        $voucher = Voucher::find($id);
        $voucher->delete();

        return redirect()->back()->with('success', 'Voucher deleted successfully');
    }

    
    public function available()
    {
    
            $vouchers = Voucher::where('status', 0)->orderBy('id', 'desc')->paginate(10);
        

        return view('admin.voucher.available', compact('vouchers'));
    }
    


}
