<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Variation;
use App\Models\Vseed;
use Illuminate\Http\Request;

class VariationController extends Controller
{
    public function create($id){
        $vseeds = Vseed::all();

        return view('admin.variation.variation_create', compact('id', 'vseeds'));
    }

    public function store(Request $request){

        $this->validate($request, [
            'title' => 'required',
            'price' => 'required',
            'stock' => 'required',
        ]);


        $variation = new Variation();
        $variation->product_id = $request->id;
        $variation->title = $request->title;
        $variation->price = $request->price;
        $variation->stock = $request->stock;
        $variation->automatic = $request->automatic;
        $variation->save();

        $url = url('admin/product/'.$request->id.'/edit');

        return redirect($url)->with('success', 'Variation created successfully');
    }

    public function delete($id){
        $variation = Variation::find($id);
        $variation->delete();

        $url = url('admin/product/'.$variation->product_id.'/edit');
        return redirect()->back()->with('success', 'Variation deleted successfully');
    }

    public function edit($id){
        $variation = Variation::find($id);

        return view('admin.variation.variation_edit', compact('variation', 'id'));
    }


    public function update(Request $request, $id){
        $this->validate($request, [
            'title' => 'required',
            'price' => 'required',
            'stock' => 'required',
        ]);


        $variation = Variation::find($id);
        $variation->title = $request->title;
        $variation->price = $request->price;
        $variation->stock = $request->stock;
        $variation->save();

        // return $variation;

        $url = url('admin/product/'.$variation->product_id.'/edit');

        return redirect($url)->with('success', 'Variation updated successfully');
    }

    public function list(Request $request){
        if ($request->key != null || $request->from != null || $request->to != null) {
            $key = $request->key;
            $from = $request->from;
            $to = $request->to;

            $query = Variation::query();
            if (isset($key)) {
                $query->where(function ($q) use ($key) {
                    $q->orWhere('title', 'like', '%'.$key.'%');
                });
            }
            if (isset($from) && isset($to)) {
                $query->where(function ($q) use ($from, $to) {
                    $q->WhereBetween('created_at', [$from, $to]);
                });
            }
            $variations = $query->paginate(15);
        } else {
            $variations = Variation::orderBy('id', 'desc')->paginate(15);
        }

        return view('admin.variation.variation_list', compact('variations'));
    }
}
