<?php

namespace App\Http\Controllers\Admin;

use App\Models\Page;
use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Menu;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class SettingController extends Controller
{

    public function index()
    {
        // Retrieve all settings as key-value pairs
        $settings = Setting::all()->pluck('value', 'key')->toArray();

        return view('admin.setting.index', compact('settings'));
    }


    public function CronJobs()
    {
        // Get the current domain dynamically
        $currentDomain = request()->getSchemeAndHttpHost(); // Returns https://yourdomain.com
    
        // Construct the full Cron URL
        $cronUrl = "/usr/bin/curl -s \"{$currentDomain}/schedule-run\" >/dev/null 2>&1";
    
        return view('admin.setting.cronjobs', compact('cronUrl'));
    }
    

  

    public function AdminUpdate(Request $request)
    {
        // Define validation rules 
        $rules = [
            'support_phone' => 'nullable|string|max:20',
            'footer_email' => 'nullable|email',
            'footer_copyright' => 'nullable|string|max:255',
            'notice_board' => 'nullable|string|max:255',
            'facebook_url' => 'nullable|url',
            'messenger_url' => 'nullable|url',
            'youtube_url' => 'nullable|url',
            'youtube_video' => 'nullable|url',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // 2MB Max
            'og_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // 2MB Max
            'twitter_image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // 2MB Max
            'favicon' => 'nullable|image|mimes:jpeg,png,jpg,gif,ico|max:2048', // 2MB Max
            'site_title' => 'nullable|string|max:255',
            'PopupText' => 'nullable|string|max:255',
            'meta_keywords' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:255',
            'custom_js' => 'nullable|string',
            'auto_remove_order' => 'nullable|string',
            'whatsapp_message_api_enabled' => 'nullable|string',
            'whatsapp_message_api' => 'nullable|string',
            'whatsapp_admin_number' => 'nullable|string',
            'whatsapp_sender_number' => 'nullable|string',
            'popup_enabled' => 'required|in:true,false',
        ];

        // Validate the incoming request data
        $validated = $request->validate($rules);

        $validated['popup_enabled'] = $request->input('popup_enabled') === 'true';
        $validated['chat_enabled'] = $request->input('chat_enabled') === '1';

        // Update each setting in the database
        foreach ($validated as $key => $value) {
            $setting = Setting::where('key', $key)->first();
            if ($setting) {
                $setting->value = $value;
                $setting->save();
            }
        }

        $publicPath = public_path('upload');

        // Handle the logo upload
        if ($request->hasFile('logo')) {
            $logo = $request->file('logo');
            $logoName = uniqid('logo_') . '.' . $logo->getClientOriginalExtension();
            $logo->move($publicPath, $logoName);
            Setting::updateOrCreate(['key' => 'logo'], ['value' => 'public/upload/' . $logoName]);
        }

        // Handle the OG image upload
        if ($request->hasFile('og_image')) {
            $ogImage = $request->file('og_image');
            $ogImageName = uniqid('og_image_') . '.' . $ogImage->getClientOriginalExtension();
            $ogImage->move($publicPath, $ogImageName);
            Setting::updateOrCreate(['key' => 'og_image'], ['value' => 'public/upload/' . $ogImageName]);
        }

        // Handle the Twitter image upload
        if ($request->hasFile('twitter_image')) {
            $twitterImage = $request->file('twitter_image');
            $twitterImageName = uniqid('twitter_image_') . '.' . $twitterImage->getClientOriginalExtension();
            $twitterImage->move($publicPath, $twitterImageName);
            Setting::updateOrCreate(['key' => 'twitter_image'], ['value' => 'public/upload/' . $twitterImageName]);
        }

        // Handle the favicon upload
        if ($request->hasFile('favicon')) {
            $favicon = $request->file('favicon');
            $faviconName = uniqid('favicon_') . '.' . $favicon->getClientOriginalExtension();
            $favicon->move($publicPath, $faviconName);
            Setting::updateOrCreate(['key' => 'favicon'], ['value' => 'public/upload/' . $faviconName]);
        }

        return redirect()->route('admin.setting.index')->with('success', 'Settings updated successfully.');
    }




    public function show($slug)
    {
        // Fetch the page by slug
        $page = Page::where('slug', $slug)->firstOrFail();

        // Return the page content view
        return view('layouts.frontend.partial.pages', compact('page'));
    }

    public function footerPages()
    {
        // Fetch all pages to show in the footer
        $pages = Page::all();

        // Return or share this data in the footer view
        return view('layouts.frontend.partial.footer', compact('pages'));
    }


    public function AdminPageindex()
    {
        $pages = Page::all();  // Renaming variable for clarity (multiple pages)
        return view('layouts.admin.partials.pages_update', compact('pages'));
    }

    // Show the form for editing the specified page
    public function PageEdit($id)
    {
        $pages = Page::findOrFail($id);  // Find the page by ID
        return view('layouts.admin.partials.pages_update', compact('pages'));  // Pass the page variable to the view
    }


    public function AdminUpdatePage(Request $request)
    {
        $pagesData = $request->input('pages'); // Get all pages data from the request

        foreach ($pagesData as $id => $data) {
            $page = Page::findOrFail($id); // Find the page by ID
            $page->title = $data['title'];
            $page->content = $data['content'];
            $page->save(); // Save the updated page
        }

        return redirect()->route('admin.pages.index')->with('success', 'Pages updated successfully');
    }



    public function MenuSetting()
    {
        // Retrieve all settings as key-value pairs
        $menus = Menu::where('status', 1)->get();
        return view('admin.setting.menu', compact('menus'));
    } // End Method




    public function update(Request $request, $id)
    {
        // Validation can be added here
        $menu = Menu::findOrFail($id);

        $menu->name = $request->name;
        $menu->link = $request->link;
        $menu->icon = $request->icon;
        $menu->status = $request->status;
        $menu->created_at = $request->created_at;
        $menu->save();

        return redirect()->back()->with('success', 'Menu updated successfully.');
    }


    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'link' => 'required',
            'icon' => 'required|string|max:255',
            'status' => 'required|boolean',
        ]);

        Menu::create($validatedData);

        return redirect()->back()->with('success', 'Menu created successfully!');
    }

    public function destroy($id)
    {
        $menu = Menu::findOrFail($id); // Find the menu by ID or fail
        $menu->delete(); // Delete the menu item

        // Redirect with success message
        return redirect()->back()->with('success', 'Menu deleted successfully.');
    }




    public function ColorSetting()
    {
        $Colorsettings = Setting::all()->pluck('value', 'key')->toArray();
        //dd($Colorsettings);
        return view('admin.setting.color', compact('Colorsettings'));
    }


    public function ColorSettingUpdate(Request $request)
    {
        // Get all the color fields from the request
        $colors = $request->only([
            'theme_color', 
            'logo_color', 
            'primary_font_color', 
            'navigation_background_color', 
            'navigation_font_color', 
            'footer_color', 
            'footer_font_color', 
            'content_box_color', 
            'notice_font_color', 
            'notice_background_color',
            'footer_info', 
            'content_heading_color', 
            'support_link_hover_color', 
            'nav_link_color', 
            'nav_link_hover_color', 
            'social_media_color', 
            'footer_rights_color'
        ]);
    
        // Update or create settings for each color field
        foreach ($colors as $key => $value) {
            Setting::updateOrCreate(['key' => $key], ['value' => $value]);
        }
    
        return redirect()->back()->with('success', 'Color settings updated successfully!');
    }

}
