<?php

namespace App\Http\Controllers\admin;

use App\Models\User;
use App\Models\Order;
use App\Models\Product;
use App\Models\Voucher;
use App\Models\Variation;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class DashboardController extends Controller
{ 
    
    
    public function dashboard(){
    // Aggregate counts in fewer queries
    $orderStats = Order::selectRaw('
        COUNT(*) as total_orders,
        SUM(auto_status = 2) as total_orders_auto,
        SUM(status = 1) as total_orders_processing,
        SUM(auto_status = 3) as total_orders_auto_cancel,
        SUM(status = 2) as total_orders_manual,
        SUM(status = 0) as pending_orders
    ')->first();

    // Individual counts for unrelated models
    $products = Product::count();
    $variations = Variation::count();
    $vouchers = Voucher::where('status', 0)->count();
    $totalUsers = User::count();

    // Latest orders for the view
    $ordersView = Order::latest()->paginate(5);

 // Sales calculations (only where status = 2 OR auto_status = 2)
 $todaySales = Order::where(function ($query) {
    $query->where('status', 2)
          ->orWhere('auto_status', 2);
})
->whereDate('created_at', Carbon::today())
->sum('total_price');

$weekSales = Order::where(function ($query) {
    $query->where('status', 2)
          ->orWhere('auto_status', 2);
})
->whereBetween('created_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])
->sum('total_price');

$monthSales = Order::where(function ($query) {
    $query->where('status', 2)
          ->orWhere('auto_status', 2);
})
->whereBetween('created_at', [Carbon::now()->startOfMonth(), Carbon::now()->endOfMonth()])
->sum('total_price');

    return view('admin.index', compact(
        'products',
        'variations',
        'vouchers',
        'totalUsers',
        'orderStats',
        'ordersView',
        'todaySales',
        'weekSales',
        'monthSales'
    ));
} // End Method


    
}
