<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Setting;
use App\Models\Voucher;
use App\Models\Variation;
use Illuminate\Http\Request;

class WelcomeController extends Controller
{
    // public function welcome() {
    //     $data['products'] = Product::oldest()->get(); // Fetch products ordered by the oldest first
    
    //     return view('welcome', $data);
    // }
    
    
    public function welcome(Request $request)
    {
     // Fetch products with status = 1 ordered by the oldest first
   $data['products'] = Product::where('status', 1)->oldest()->get();
        
        // Get popup content and other settings from the settings table
        $data['popupContent'] = Setting::where('key', 'PopupText')->value('value');
        $data['logo'] = Setting::where('key', 'logo')->value('value');
        $data['youtubeVideo'] = Setting::where('key', 'youtube_video')->value('value');
        $popupEnabled = Setting::where('key', 'popup_enabled')->value('value'); // Check if popup is enabled
        
        // Check if popup is enabled and if the user has visited before to show the popup
        if ($popupEnabled == '1' && !$request->session()->has('popup_shown')) {
            $request->session()->put('popup_shown', true); // Mark popup as shown
            $data['showPopup'] = true;
        } else {
            $data['showPopup'] = false;
        }
    
        return view('frontend.index', $data); 
    }
    
   

    public function topup($slug)
    {
        $product = $data['product'] = Product::where('slug', $slug)
            ->first();

        if ($product->type == 'voucher') {
            $data['vouchers'] = Voucher::where('product_id', $product->id)
                ->groupBy('variation')
                ->get();
        }
        if ($product->type == 'topup') {
            $data['variations'] = Variation::where('product_id', $product->id)
                ->get();
        }
        // return $data;
        return view('frontend.topup', $data);
    }
}
