<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Order;
use App\Models\Payment;
use App\Models\Setting;
use App\Models\Voucher;
use App\Models\Variation;
use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class PaymentController extends Controller
{
    public function processPayment(Request $request)
    {

        
        session(['order_sumid' => null]);


        //$type = 'uddoktapay';

        // Fetch payment gateway configuration from the database
        $type = PaymentGateway::where('is_active', true)->first();

        // Fetch payment gateway configuration from the database
        $type_GreenPay = PaymentGateway::where('type', 'greenpaybd')->first();

        // Check if all payment methods are inactive
        if (!isset($type)) {
            // Return an error response
            return back()->with([
                'error' => 'Sorry, no payment methods are currently available. Please try again later.',
            ]);
        }

        if ($type->type == 'uddoktapay') {
            $request->validate([
                'amount' => 'required|numeric',
            ]);

            $baseURL = $type->base_url; //'https://sandbox.uddoktapay.com/';
            $apiKEY = $type->api_key; //'982d381360a69d419689740d9f2e26ce36fb7a50';

            $fields = [
                'full_name' => Auth::user()->name,
                'email' => Auth::user()->email,
                'amount' => $request->amount,
                'metadata' => [
                    'user_id' => Auth::user()->id,
                    'order_id' => '',
                ],
                'redirect_url' => url('uddoktapay/success'),
                'return_type' => 'GET',
                'cancel_url' => url('uddoktapay/cancel'),
                'webhook_url' => url('uddoktapay/webhook'),
            ];
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => $baseURL . 'api/checkout-v2',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($fields),
                CURLOPT_HTTPHEADER => ['RT-UDDOKTAPAY-API-KEY: ' . $apiKEY, 'accept: application/json', 'content-type: application/json'],
            ]);

            $order = new Payment();
            $order->user_id = Auth::user()->id;
            $order->amount = $request->amount;
            $order->payment_status = 'pending';
            $order->transaction_id = uniqid();
            $order->save();

            session(['payment_idx' => $order->id]);

            $response = curl_exec($curl);
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                echo 'cURL Error #:' . $err;
            } else {
                $responseData = json_decode($response, true);
                return redirect($responseData['payment_url']);
            }
        }

        if ($type->type == 'greenpaybd') {
            $request->validate([
                'amount' => 'required|numeric',
            ]);

            // Define payment details
            $api = $type_GreenPay->api_key;
            $client = $type_GreenPay->client;
            $secret = $type_GreenPay->secret;
            $amount = $request->input('amount');
            $position = $type_GreenPay->base_url;

            // Retrieve authenticated user's information
            $customer = auth()->user()->name;
            $customerEmail = auth()->user()->email;

            // Define the URLs
            $successUrl = route('successPage', ['amount' => $amount]);
            $cancelUrl = route('greenpay.cancel');

            // Create the order before redirecting to payment
            $order = new Payment();
            $order->user_id = Auth::user()->id;
            $order->amount = $amount;
            $order->payment_status = 'pending';
            $order->transaction_id = uniqid();
            $order->save();

            // Store the transaction ID in session to use later
            session(['payment_idx' => $order->id]); // Store the order ID in session

            // Construct the payment URL
            $paymentUrl = "https://pay.greenpaybd.com/woocommerce_checkout.php?api=$api&client=$client&secret=$secret&amount=$amount&position=$position&success_url=$successUrl&cancel_url=$cancelUrl&cus_name=" . urlencode($customer) . '&cus_email=' . urlencode($customerEmail) . '&done';

            // Redirect to payment URL
            return redirect()->away($paymentUrl);
        }

        session(['order_sumid' => null]);


        if ($type->type == 'drutopay') {
            $gateway = PaymentGateway::where('type', 'drutopay')->where('is_active', 1)->first();
        
            if (!$gateway) {
                return response()->json(['status' => false, 'message' => 'Active Drutopay gateway not found'], 404);
            }
        
            $user = Auth::user();
            if (!$user) {
                return response()->json(['status' => false, 'message' => 'User not authenticated'], 401);
            }
        
            $payment = new Payment();
            $payment->user_id = Auth::user()->id;
            $payment->amount = $request->amount;
            $payment->payment_status = 'pending';
            $payment->transaction_id = uniqid();
            $payment->save();
        
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://pay.drutopay.com/api/payment/create',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{"success_url":"' . url('drutopay/success') . '","cancel_url":"' . url('drutopay/cancel') . '","metadata":{"phone":"' . Auth::user()->phone . '","order_id":""},"amount":"' . $request->amount . '"}',
                CURLOPT_HTTPHEADER => [
                    'API-KEY: ' . $gateway->api_key,
                    'SECRET-KEY: ' . $gateway->secret,
                    'BRAND-KEY: ' . $gateway->client,
                    'Content-Type: application/json',
                ],
            ]);
        
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
        
            if ($err) {
                Log::error('Drutopay cURL Error: ' . $err);
                return back()->with('error', 'Payment processing failed');
            } else {
                session(['payment_idx' => $payment->id]);
                session(['order_sumid' => null]); // এখানে অর্ডার না থাকলে null
        
                $data = json_decode($response, true);
                Log::info('Drutopay Payment Initiated: Payment ID ' . $payment->id);
                return redirect($data['payment_url']);
            }
        }
    }
      // before voucer  auto order insert
    // public function successPage(Request $request)
    // {
    //     // Retrieve the transaction ID and other details from the query parameters
    //     $transactionId = $request->query('transactionId');
    //     $paymentAmount = $request->query('paymentAmount');
    //     $paymentFee = $request->query('paymentFee');

    //     // Verify the transaction using the API
    //     $response = Http::asForm()->post('https://pay.greenpaybd.com/verify.php', [
    //         'transaction_id' => $transactionId,
    //     ]);

    //     // Check if the response is successful and valid
    //     if ($response->successful() && ($response->body() == 1 || $response->body() === true)) {
    //         // Payment verification successful, update payment status
    //         $paymentId = session()->get('payment_idx');
    //         $order_sumid = session()->get('order_sumid');

    //         if ($paymentId) {
    //             $order = Payment::find($paymentId);

    //             // Check if the order exists
    //             if ($order) {
    //                 // Update the order payment status
    //                 $order->payment_status = 'completed'; // Update payment status
    //                 $order->transaction_id = $transactionId; // Update the transaction ID
    //                 $order->save(); // Save the order details

    //                 // Update user's wallet_credit and wallet_credit_expiry based on package_type

    //                 if ($order_sumid == null) {
    //                     $user = User::find($order->user_id); // Find the user who made the order
    //                     if ($user) {
    //                         $user->balance = $user->balance + $order->amount;
    //                         $user->save();
    //                     }
    //                 } else {
    //                     $myorders = Order::where('order_sumid', $order_sumid)->get();

    //                     foreach ($myorders as $myorder) {

    //                         //Ridoy added condition for ingame
    //                         $myorder->status = $myorder->type == 'topup' || $myorder->type == 'ingame' ? 1 : 2;

    //                        // $myorder->status = 2;
    //                         $myorder->save();

    //                         $voucher = Voucher::find($myorder->voucher_id);
    //                         if (isset($voucher)) {
    //                             $voucher->status = 1;
    //                             $myorder->payment_type = 'wallet';
    //                             $voucher->save();
    //                         }

    //                         $variation = Variation::find($myorder->variation_id);
    //                         $variation->stock = $variation->stock - 1;
    //                         $variation->save();
    //                     }
    //                 }

    //                 // Clear the session payment index
    //                 session()->forget('payment_idx');

    //                 return redirect('user/dashboard')->with('success', 'Payment successfully processed, wallet updated');
    //             } else {
    //                 return redirect('user/dashboard')->with('error', 'Order not found');
    //             }
    //         } else {
    //             return redirect('user/dashboard')->with('error', 'Payment record not found');
    //         }
    //     } else {
    //         return redirect('user/dashboard')->with('error', 'Payment verification failed');
    //     }
    // }


    public function successPage(Request $request)
{
    $transactionId = $request->query('transactionId');
    $paymentAmount = $request->query('paymentAmount');
    $paymentFee = $request->query('paymentFee');

    $response = Http::asForm()->post('https://pay.greenpaybd.com/verify.php', [
        'transaction_id' => $transactionId,
    ]);

    if ($response->successful() && ($response->body() == 1 || $response->body() === true)) {
        $paymentId = session()->get('payment_idx');
        $order_sumid = session()->get('order_sumid');

        if ($paymentId) {
            $payment = Payment::find($paymentId);
            if ($payment) {
                $payment->payment_status = 'completed';
                $payment->transaction_id = $transactionId;
                $payment->save();

                Log::info('GreenPay Payment Success: Payment ID ' . $paymentId . ', Amount: ' . $payment->amount);

                if ($order_sumid) {
                    $orders = Order::where('order_sumid', $order_sumid)->get();
                    foreach ($orders as $order) {
                        // ভাউচার যোগ
                        if (!$order->voucher_id) {
                            $voucher = Voucher::where('variation', $order->variation_id)
                                ->where('status', 0)
                                ->first();
                            if ($voucher) {
                                $voucher->status = 1;
                                $voucher->save();
                                $order->voucher_id = $voucher->id;
                                $order->automatic = $voucher->automatic;
                                Log::info('Voucher Added: Order ID ' . $order->id . ', Voucher ID: ' . $voucher->id);
                            } else {
                                Log::warning('No voucher available for Order ID ' . $order->id);
                            }
                        }

                        // স্ট্যাটাস আপডেট
                        $order->status = $order->type == 'topup' || $order->type == 'ingame' ? 1 : 2;
                        $order->save();

                        // স্টক কমানো
                        $variation = Variation::find($order->variation_id);
                        if ($variation) {
                            $variation->stock -= 1;
                            $variation->save();
                            Log::info('Stock Updated: Variation ID ' . $variation->id . ', New Stock: ' . $variation->stock);
                        }
                    }
                } else {
                    // অর্ডার না থাকলে ব্যালেন্সে টাকা যোগ
                    $user = User::find($payment->user_id);
                    if ($user) {
                        $user->balance += $payment->amount;
                        $user->save();
                        Log::info('Balance Updated: User ID ' . $user->id . ', Added Amount: ' . $payment->amount);
                    }
                }

                session()->forget('payment_idx');
                session()->forget('order_sumid');

                return redirect('user/dashboard')->with('success', 'Payment successfully processed, wallet updated');
            } else {
                return redirect('user/dashboard')->with('error', 'Order not found');
            }
        } else {
            return redirect('user/dashboard')->with('error', 'Payment record not found');
        }
    } else {
        return redirect('user/dashboard')->with('error', 'Payment verification failed');
    }
}

    public function cancel()
    {
        return view('frontend.payment_cancel');
    }
}
