@extends('admin.admin_dashboard')
@section('admin')
    <div class="page-content">
        <!-- Page Heading -->
        <h1 class="h3 mb-4 text-gray-800">Update Pages</h1>

        <!-- Single form for updating all pages -->
        <form action="{{ route('admin.pages.update') }}" method="POST">  <!-- Use a new route for updating all pages -->
            @csrf

            @foreach($pages as $page)
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Edit Page: {{ $page->title }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="title_{{ $page->id }}">Title</label>
                            <input type="text" class="form-control" id="title_{{ $page->id }}" name="pages[{{ $page->id }}][title]" value="{{ $page->title }}" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="content_{{ $page->id }}">Content</label>
                            <textarea class="form-control" id="content_{{ $page->id }}" name="pages[{{ $page->id }}][content]" rows="5" required>{{ $page->content }}</textarea>
                        </div>
                    </div>
                </div>
            @endforeach

            <button type="submit" class="btn btn-primary">Update All Pages</button>
        </form>
    </div>
@endsection

@section('js')
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery/jquery.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/js/sb-admin-2.min.js"></script>
@endsection
