<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Cancelled - Rex Gaming BD</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- Custom CSS -->
    <style>
        body {
            background-color: #f8f9fa;
        }
        .cancel-container {
            margin-top: 80px;
            margin-bottom: 80px;
        }
        .alert-custom {
            border: 2px solid #dc3545;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
        .icon-circle {
            background-color: #ffe5e5;
            width: 100px;
            height: 100px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        .btn-custom {
            padding: 10px 25px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-custom:hover {
            transform: translateY(-2px);
        }
    </style>
</head>
<body>

<!-- Payment Cancellation Message -->
<div class="container cancel-container">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="alert alert-custom p-4 rounded-4">
                <div class="icon-circle">
                    <i class="bi bi-x-circle-fill" style="font-size: 3.5rem; color: #dc3545;"></i>
                </div>
                <h2 class="alert-heading text-center mb-3">পেমেন্ট বাতিল করা হয়েছে</h2>
                <p class="text-center fs-5">আপনার পেমেন্ট সম্পূর্ণ হয়নি। এটি একটি ভুল হলে, আপনি আবার চেষ্টা করতে পারেন বা সহায়তার জন্য আমাদের সহায়তা দলের সাথে যোগাযোগ করতে পারেন।</p>
                <hr>
                <div class="text-center">
                    <p class="mb-2">Order ID: <strong>#123456</strong></p>
                    <p class="mb-4">Date: <strong>{{ date('F d, Y') }}</strong></p>
                    
                    <div class="d-grid gap-2 d-sm-flex justify-content-sm-center">
                        <a href="/user/fund" class="btn btn-primary btn-custom me-sm-3">
                            <i class="bi bi-arrow-repeat me-2"></i>পুনরায় চেষ্টা করুন
                        </a>
                        <a href="/contact-us" class="btn btn-outline-secondary btn-custom">
                            <i class="bi bi-headset me-2"></i>সাপোর্ট
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Bootstrap 5 JS Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>