<!DOCTYPE html>
<html lang="en">

<head>
    <!-- PHP Script -->

    @php
        $settingsKeys = [
            'site_title',
            'meta_description',
            'meta_keywords',
            'og_image',
            'favicon',
            'theme_color',
            'logo_color',
            'primary_font_color',
            'navigation_background_color',
            'footer_color',
            'footer_font_color',
            'content_box_color',
            'notice_font_color',
            'notice_background_color',
        ];
        $settings = Cache::remember('site_settings', 3600, function () use ($settingsKeys) {
            return App\Models\Setting::whereIn('key', $settingsKeys)->pluck('value', 'key');
        });
    @endphp


    <!-- Meta Tags -->
    <meta charset="UTF-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, maximum-scale=1.2, minimum-scale=0.7, user-scalable=no">
    <meta name="description" content="{{ $settings['meta_description'] ?? 'Default Description' }}">
    <meta name="keywords" content="{{ $settings['meta_keywords'] ?? 'Default Keywords' }}">
    <meta name="robots" content="index, follow">
    <title>{{ $settings['site_title'] ?? 'Best Topup Site' }}</title>
    <link rel="canonical" href="{{ url()->current() }}">

  
   <!-- Favicon live -->
   {{-- <link rel="icon" href="{{ asset('public/'.$settings['favicon'] ?? 'default-favicon.ico') }}"> --}}



    <!-- Favicon Offline -->
  <link rel="icon" href="{{ url($settings['favicon'] ?? 'path/to/default/favicon.ico') }}">

  

    <!-- Open Graph Meta Tags -->
    <meta property="og:image" content="{{ asset($settings['og_image'] ?? 'default-og-image.png') }}">

    <meta property="og:title" content="{{ $settings['site_title'] ?? 'Default Site Title' }}">
    <meta property="og:description" content="{{ $settings['meta_description'] ?? 'Best Topup Site' }}">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta name="twitter:card" content="summary_large_image">
    <!-- Twitter Meta Tags -->
    <meta name="twitter:image" content="{{ asset($settings['og_image'] ?? 'default-twitter-image.png') }}">




    <!-- Stylesheets -->
    <link rel="stylesheet" href="{{ url('public/frontend/assets/css/bootstrap/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ url('public/frontend/assets/fonts/fontawesome/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ url('public/frontend/assets/js/toastr/toastr.min.css') }}">
    <link rel="stylesheet" href="{{ url('public/frontend/assets/css/styles.css') }}">


    <!-- Manifest -->

    <link rel="manifest" href="{{ url('public/manifest.json') }}">

    <script src="{{ url('public/serviceworker.js') }}"></script>



    <!-- Inline Styles -->

    <style>
        :root {
            --theme-color:
                {{ $settings['theme_color'] ?? '#1247e6' }};
            --logo-color:
                {{ $settings['logo_color'] ?? '#424242' }};
            --primary-font-color:
                {{ $settings['primary_font_color'] ?? '#000000' }};
            --navigation-background-color:
                {{ $settings['navigation_background_color'] ?? '#f5f5f5' }};
            --navigation-font-color:
                {{ $settings['navigation_font_color'] ?? '#000000' }};
            --footer-color:
                {{ $settings['footer_color'] ?? '#080101' }};
            --footer-font-color:
                {{ $settings['footer_font_color'] ?? '#f0eded' }};
            --content-box-color:
                {{ $settings['content_box_color'] ?? '#ffffff' }};


        }


        .notice-style {
            background-color:
                {{ $settings['notice_background_color'] ?? '#1247e6' }};
            color:
                {{ $settings['notice_font_color'] ?? '#1247e6' }};
        }
    </style>

</head>

<body>


    @include('layouts.frontend.partial.header')


    @yield('content')




    @include('layouts.frontend.partial.footer')


    <!-- JavaScript -->
    <script src="{{ url('public/frontend/assets/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ url('public/frontend/assets/js/custom.js') }}"></script>
    <script src="{{ url('public/frontend/assets/js/bootstrap/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ url('public/frontend/assets/js/toastr/toastr.min.js') }}"></script>

    {{-- <script>
        (function() {
            const minZoom = 0.7; // Minimum zoom level (70%)
            const maxZoom = 1.2; // Maximum zoom level (120%)

            function enforceZoom() {
                const currentZoom = window.outerWidth / window.innerWidth;

                if (currentZoom < minZoom) {
                    alert("Zooming out is restricted below 70%!");
                    document.body.style.transform = `scale(${minZoom})`;
                    document.body.style.transformOrigin = "top left";
                    document.body.style.width = `${100 / minZoom}%`;
                } else if (currentZoom > maxZoom) {
                    alert("Zooming in is restricted above 120%!");
                    document.body.style.transform = `scale(${maxZoom})`;
                    document.body.style.transformOrigin = "top left";
                    document.body.style.width = `${100 / maxZoom}%`;
                } else {
                    // Reset the styles when zoom is within limits
                    document.body.style.transform = "none";
                    document.body.style.width = "100%";
                }
            }

            // Run on resize (when the user attempts to zoom)
            window.addEventListener("resize", enforceZoom);

            // Run on page load
            window.addEventListener("load", enforceZoom);
        })();
    </script> --}}






</body>

</html>
