@extends('frontend.master')

@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar Image Section -->
        <div class="col-md-4 d-none d-md-block"> 
            <img src="public/login.png" alt="Login Sidebar Image" class="img-fluid">
        </div>

        <!-- Register Form Section -->
        <div class="col-12 col-sm-12 col-md-6 col-lg-6 mx-auto my-4">
            <div class="content-box shadow p-4">
               
                <h2 class="login-title mb-4">Register</h2>
                <!-- Google Login -->
                <a class="btn btn-google btn-danger w-100 mb-3" href="{{ url('auth/google') }}">
                    Login with Google
                </a>

                <div class="sign_separator">
                    <hr class="line"> Or Register <hr class="line">
                </div>

                <form method="POST" action="{{ url('register') }}">
                    @csrf
                    <div class="form-group form-group-icon mb-3">
                        <label class="control-label" for="name"><i class="fas fa-user"></i></label>
                        <input type="text" class="form-control" id="username" name="name" placeholder="Full Name" autocomplete="off" value="{{ old('name') }}">
                        @error('name')
                        <span style="color: red;">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="form-group form-group-icon mb-3">
                        <label class="control-label" for="email"><i class="fas fa-envelope"></i></label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Email Address" autocomplete="off" value="{{ old('email') }}">
                        @error('email')
                        <span style="color: red;">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="form-group form-group-icon mb-3">
                        <label class="control-label" for="phone"><i class="fas fa-phone"></i></label>
                        <input type="number" class="form-control" id="phone" name="phone" placeholder="Phone Number" autocomplete="off" value="{{ old('phone') }}">
                        @error('phone')
                        <span style="color: red;">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="form-group form-group-icon mb-3">
                        <label class="control-label" for="password"><i class="fas fa-lock"></i></label>
                        <input type="password" class="form-control" id="password" name="password" placeholder="Password" autocomplete="off">
                        @error('password')
                        <span style="color: red;">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="form-group form-group-icon mb-3">
                        <label class="control-label" for="password_confirmation"><i class="fas fa-lock"></i></label>
                        <input type="password" class="form-control" id="confirm_password" name="password_confirmation" placeholder="Confirm Password" autocomplete="off">
                        @error('password_confirmation')
                        <span style="color: red;">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="form-group mb-3">
                        <div class="form-group__checkbox">
                            <label class="form-group__checkbox-label">
                                <input type="checkbox" name="terms" value="1" id="terms" checked required>
                                <span class="checkmark"></span>
                            </label>
                            <label class="form-group__label-title" for="terms" style="display: inline;">
                                I have read and agreed with
                                <a href="page/terms.html" target="_blank" class="sign-up-center-terms-link">Terms of Service</a>
                            </label>
                        </div>
                    </div>

                    <div class="component_button_submit mb-3">
                        <button type="submit" class="btn btn-light theme-btn-block w-100">REGISTER</button>
                    </div>
                </form>

                <div class="text-center">
                    Already have an account? <a href="/login">Login</a>
                </div>
            </div>
        </div>
    </div>
</div>

@php
$menus = App\Models\Menu::all();
@endphp

<div class="sticky-footer-container">
    @foreach ($menus as $menu)
        <div class="sticky-footer-item">
            <a href="{{ $menu->link }}">
                <div class="d-flex justify-content-center align-items-center flex-column">
                    <span>{!! $menu->icon !!}</span> 
                    <span>{{ $menu->name }}</span>
                </div>
            </a>
        </div>
    @endforeach
</div>

<script>
    $(document).ready(function() {
        $('#accountButton').click(function() {
            $('.right-side-menu').toggleClass('active');
            $('#overlay').toggle();
        });

        $('#closeButton').click(function() {
            $('.right-side-menu').removeClass('active');
            $('#overlay').hide();
        });

        $('#overlay').click(function() {
            $('.right-side-menu').removeClass('active');
            $('#overlay').hide();
        });
    });
</script>
@endsection
