@extends('admin.admin_dashboard')
@section('admin')
    <div class="page-content">

        <!-- Page Heading -->
        <h1 class="h3 mb-2 text-gray-800">ALL VOUCHER LIST</h1>

        <!-- DataTales Example -->
        <div class="card shadow mb-1">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger mb-1">
                    {{ session('error') }}
                </div>
            @endif


            <!-- Begin Page Content -->
            <div class="container-fluid">
                <div class="card-body">

                    <br>
                    <div class="table-responsive">
                        <div class="table-responsive">
                            <table id="dataTableExample" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Product</th>
                                        <th>Variation</th>
                                        <th>Code</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($vouchers as $voucher)
                                        <tr>
                                            @php
                                                $product = App\Models\Product::find($voucher->product_id);
                                                $variation = App\Models\Variation::find($voucher->variation);
                                                // Fetch the first Orderitem associated with this voucher
                                                $orderItem = App\Models\Orderitem::where(
                                                    'voucher_id',
                                                    $voucher->id,
                                                )->first();
                                                // Fetch the Order and User
                                                $order = $orderItem ? $orderItem->order : null;
                                                $user = $order ? $order->user : null;
                                            @endphp
                                            <td>{{ $voucher->id }}</td>
                                            <td>{{ isset($product) ? $product->title : 'deleted' }}</td>
                                            <td>{{ isset($variation) ? $variation->title : 'deleted' }}</td>
                                            <td>{{ $voucher->code }}</td>
                                            <td>
                                                @if ($voucher->status == '1')
                                                    Used by {{ $user ? $user->name : 'Unknown User' }}
                                                @else
                                                    NOT-USED
                                                @endif
                                            </td>
                                            <td>
                                                @if (isset($variation->automatic))
                                                    Automatic
                                                @endif
                                                @if (!isset($variation->automatic))
                                                    Manual
                                                @endif
                                            </td>
                                            <td>
                                                {{ $voucher->created_at->format('d M y, h:i A') }}
                                            </td>

                                            <td>
                                                <a id="delete" href="{{ url('admin/voucher/delete', $voucher->id) }}"
                                                    class="btn btn-danger btn-circle">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                                <a href="{{ route('admin.voucher.edit', $voucher->id) }}"
                                                    class="btn btn-success btn-circle">
                                                    <i class="fas fa-pen"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            {{ $vouchers->links() }}

                        </div>
                    </div>
                </div>

            </div>

        </div>
    @endsection


    @section('js')
        <!-- Bootstrap core JavaScript-->
        <script src="{{ url('/') }}/public/assets/backend/vendor/jquery/jquery.min.js"></script>
        <script src="{{ url('/') }}/public/assets/backend/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

        <!-- Core plugin JavaScript-->
        <script src="{{ url('/') }}/public/assets/backend/vendor/jquery-easing/jquery.easing.min.js"></script>

        <!-- Custom scripts for all pages-->
        <script src="{{ url('/') }}/public/assets/backend/js/sb-admin-2.min.js"></script>

        <!-- Page level plugins -->
        <script src="{{ url('/') }}/public/assets/backend/vendor/chart.js/Chart.min.js"></script>

        <!-- Page level custom scripts -->
        <script src="{{ url('/') }}/public/assets/backend/js/demo/chart-area-demo.js"></script>
        <script src="{{ url('/') }}/public/assets/backend/js/demo/chart-pie-demo.js"></script>
    @endsection
