@extends('admin.admin_dashboard')
@section('admin')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>

<div class="page-content">
        <!-- Page Heading -->
        <h1 class="h3 mb-2 text-gray-800">ADD VOUCHER</h1>

        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <!-- Begin Page Content -->
            <div class="container-fluid">
                <div class="card-body">
                    <form action="{{ route('admin.voucher.update', $voucher->id) }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('put')
                        <div class="form-row">

                            <div class="form-group col-md-12">
                                <label>Variation</label>
                                <select name="variation" id="variation-select" class="form-control">
                                    <option value="">Please select</option>
                                    @foreach ($variations as $variation)
                                        <option value="{{ $variation->id }}" {{ $variation->id == $voucher->variation ? 'selected' : '' }}>{{ $variation->title }}</option>
                                    @endforeach
                                </select>
                                @error('variation')
                                    <span style="color: red;">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>


                            <div class="form-group col-md-12">
                                <label>Code</label>
                                <input type="text" name="code" class="form-control"
                                value="{{ $voucher->code }}" placeholder="Enter code"/>
                                @error('code')
                                    <span style="color: red;">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                        </div>

                        <button type="submit" class="btn btn-primary">UPDATE</button>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <!-- Bootstrap core JavaScript-->
    <script src="{{ url('/') }}/public/assets/backend/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{ url('/') }}/public/assets/backend/js/sb-admin-2.min.js"></script>

    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            // Initialize Select2 on the select element
            $('#variation-select').select2({
                placeholder: "Please select a variation",
                allowClear: true
            });
        });
    </script>
@endsection
