@extends('admin.admin_dashboard')

@section('admin')
<div class="page-content">
    <h1 class="h3 mb-2 text-gray-800">{{ $user->name }} এই ইউজারের সকল ট্রানজেকশন</h1>

    <div class="table-responsive mt-4">
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>তারিখ</th>
                    <th>আগের ব্যালেন্স</th>
                    <th>এমাউন্ট</th>
                    <th>নতুন ব্যালেন্স</th>
                    <th>ট্রানজেকশন আইডি</th>
                    <th>স্ট্যাটাস</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($transactions as $transaction)
                    <tr>
                        <td>{{ $transaction->created_at->format('d M Y H:i A') }}</td>
                        <td>৳ {{ number_format($transaction->previous_balance, 2) }}</td>
                        <td>৳ {{ number_format($transaction->amount, 2) }}</td>
                        <td>৳ {{ number_format($transaction->new_balance, 2) }}</td>
                        <td>{{ $transaction->transaction_id }}</td>
                        <td>
                            @if ($transaction->payment_status == 'completed')
                                <span class="badge bg-success">Completed</span>
                            @else
                                <span class="badge bg-warning">Pending</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center">কোনো ট্রানজেকশন পাওয়া যায়নি।</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection