@extends('admin.admin_dashboard')

@section('admin')

    <div class="page-content">
        <h1 class="h3 mb-4 text-gray-800">Cron Jobs</h1>

        <div class="card shadow mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Cron Job Command</h5>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="cron_url">Cron Job Command:</label>
                    <div class="input-group">
                        <input type="text" class="form-control" id="cron_url" value="{{ $cronUrl }}" readonly>
                        <button class="btn btn-primary" onclick="copyCronURL()">📋 Copy</button>
                    </div>
                </div>
                <p id="copy_message" class="text-success mt-2" style="display: none;">✅ Copied to clipboard!</p>
            </div>
        </div>
    </div>

    <script>
        function copyCronURL() {
            var copyText = document.getElementById("cron_url");
            copyText.select();
            copyText.setSelectionRange(0, 99999); // For mobile devices
            document.execCommand("copy");

            // Show confirmation message
            var message = document.getElementById("copy_message");
            message.style.display = "block";
            setTimeout(() => message.style.display = "none", 2000);
        }
    </script>

@endsection
