@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">



        <!-- Page Heading -->
        <h1 class="h3 mb-2 text-gray-800">PRODUCT LIST</h1>

        <!-- DataTales Example -->
        <div class="card shadow mb-1">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger mb-1">
                    {{ session('error') }}
                </div>
            @endif


            <!-- Begin Page Content -->
            <div class="container-fluid">
                <div class="card-body">
                   
                    <br>
                    <div class="table-responsive">
                        <table id="dataTableExample" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($products as $product)
                                    <tr>
                                        <td>{{ \Illuminate\Support\Str::limit($product->title, 50, $end = '...') }}</td>
                                        <td>{{ $product->type }}</td>
                                        <td><img src="{{ url('/').'/'.$product->image }}" style="width: 50px"></td>
                                        <td>{{ $product->status == '1' ? 'Active' : 'Inactive' }}</td>
                                        <td>
                                            <a onclick="return confirm('Are you sure to delete ?')" href="{{ url('admin/product/delete', $product->id) }}"
                                                class="btn btn-danger btn-circle">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                            <a href="{{ route('admin.product.edit', $product->id) }}"
                                                class="btn btn-success btn-circle">
                                                <i class="fas fa-pen"></i>
                                            </a>
                                            <a href="{{ url('/', $product->slug) }}" class="btn btn-success btn-circle" target="_blank">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach


                            </tbody>
                        </table>

                        {{ $products->links() }}

                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection


