@extends('admin.admin_dashboard')
@section('admin')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>

<div class="page-content">


        <!-- Page Heading -->
        <h1 class="h3 mb-2 text-gray-800">UPDATE PRODUCT</h1>

        <!-- DataTales Example -->
        <div class="card shadow mb-4">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif


            <!-- Begin Page Content -->
            <div class="container-fluid">
                <div class="card-body">
                    <form action="{{ route('admin.product.update', $product->id) }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('put')
                        <div class="row">
                            <div class="col-sm-8">
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>Title</label>
                                        <input type="text" name="title" class="form-control"
                                            value="{{ $product->title }}" placeholder="Enter title" id="title" />
                                        <span class="text-muted" id="titleCount">0/100</span>
                                        @error('title')
                                            <br>
                                            <span style="color: red;">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>Slug</label>
                                        <input type="text" name="slug" class="form-control"
                                            value="{{ $product->slug }}" placeholder="Enter slug" id="slug" />
                                        @error('slug')
                                            <span style="color: red;">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-row">
                                    <div class="container">
                                        <div class="form-group">
                                            <label for="imageInput">Choose Image:</label>
                                            <input type="file" name="image" class="form-control-file" id="imageInput">
                                        </div>
                                        <div class="card" style="width: 18rem;">
                                            <img src="{{ url('/').'/'.$product->image }}" class="card-img-top" alt="Selected Image"
                                                id="selectedImage">
                                        </div>
                                        @error('image')
                                            <span style="color: red;">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                            </div>


                            <div class="col-sm-8">
                                <div class="form-row">
                                    <label>Type</label>
                                    <select class="form-control" name="type">
                                        <option value="">Please select:</option>
                                        <option value="topup" {{ $product->type == 'topup' ? 'selected' : '' }}>Topup
                                        </option>
                                        <option value="ingame" {{ $product->type == 'ingame' ? 'selected' : '' }}>In Game
                                        </option>
                                        <option value="voucher" {{ $product->type == 'voucher' ? 'selected' : '' }}>Voucher
                                        </option>
                                    </select>
                                    @error('type')
                                        <span style="color: red;">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-8 mt-3">
                                <div class="form-row">
                                    <label>Status</label>
                                    <select class="form-control" name="status">
                                        <option value="">Please select:</option>
                                        <option value="1" {{ $product->status == '1' ? 'selected' : '' }}>Active</option>
                                        <option value="0" {{ $product->status == '0' ? 'selected' : '' }}>Inactive
                                        </option>
                                    </select>
                                    @error('status')
                                        <span style="color: red;">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>



                        <div class="form-row mt-3">
                            <div class="form-group col-md-12">
                                <label>Post Description</label>
                                <textarea class="form-control" id="editor1" name="content">{{ $product->content }}</textarea>
                                <span class="text-muted" id="detailsCount">0/500</span>
                                <br>
                                @error('content')
                                    <span style="color: red;">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">UPDATE</button>
                    </form>
                </div>
            </div>

            <div class="container-fluid">
                <div class="card-body">
                    <form action="{{ url('admin/product') }}" method="get">
                        @csrf
                        <div class="form-row align-items-center">   
                            <div class="col-auto my-1">
                                <a href="{{ url('admin/variation/create', $product->id) }}" class="btn btn-success">ADD NEW</a>
                            </div>
                        </div>

                    </form>
                    <br>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($variations as $variation)
                                <tr>
                                    <td>{{ $variation->title }}</td>
                                    <td>{{ $variation->price }}</td>
                                    <td>{{ $variation->stock }}</td>
                                    <td>
                                        @if (isset($variation->automatic))
                                            Automatic
                                        @endif
                                        @if (!isset($variation->automatic))
                                            Manual
                                        @endif
                                    </td>
                                    <td>
                                        <a onclick="return confirm('Are you sure to delete ?')" href="{{ url('admin/variation/delete', $variation->id) }}"
                                            class="btn btn-danger btn-circle">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                        <a href="{{ url('admin/variation/edit', $variation->id) }}"
                                            class="btn btn-success btn-circle">
                                            <i class="fas fa-pen"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>



                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection


@section('js')
    <!-- Bootstrap core JavaScript-->
    <script>
        $(document).ready(function() {
            // Function to update character count
            function updateCharCount(element, countElement, maxLength) {
                var count = element.val().length;
                countElement.text(count + '/' + maxLength);
            }

            // Character count for Title
            $('#title').keyup(function() {
                updateCharCount($(this), $('#titleCount'), 100);
            });

            // Character count for Search Keywords
            $('#searchKeyword').keyup(function() {
                updateCharCount($(this), $('#searchKeywordCount'), 200);
            });

            // Character count for Meta Description
            $('#metaDescription').keyup(function() {
                updateCharCount($(this), $('#metaDescriptionCount'), 250);
            });

            // Character count for Post Description
            $('#editor1').keyup(function() {
                updateCharCount($(this), $('#detailsCount'), 500);
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#imageInput').on('change', function() {
                var input = this;
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#selectedImage').attr('src', e.target.result);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            });
        });
    </script>

    <script src="{{ url('/') }}/public/assets/backend/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{ url('/') }}/public/assets/backend/js/sb-admin-2.min.js"></script>

    <script src="{{ url('/') }}/public/assets/editor/ckeditor/ckeditor.js"></script>
    <script src="{{ url('/') }}/public/assets/editor/ckeditor/adapters/jquery.js"></script>
    <script src="{{ url('/') }}/public/assets/editor/ckeditor/styles.js"></script>
    <script src="{{ url('/') }}/public/assets/editor/ckeditor/ckeditor.custom.js"></script>
@endsection
