@extends('admin.admin_dashboard')

@section('admin')
    <div class="page-content">
        <h1 class="h3 mb-4 text-gray-800">Bkash Merchant Payment Settings</h1>

        <form action="{{ route('bkash.payment_gateways.update') }}" method="POST">
            @csrf

            <!-- Bkash Merchant Status -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-center">Bkash Merchant Status</h6>
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label class="d-block font-weight-bold">Merchant Status</label>

                        @php
                            $merchantStatus = $bkashSettings['bkash_merchant_enable'] ?? '0';
                        @endphp

                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="bkash_merchant_enable" value="1"
                                   id="bkash_active" {{ $merchantStatus == '1' ? 'checked' : '' }}>
                            <label class="form-check-label" for="bkash_active">✅ Active</label>
                        </div>

                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="bkash_merchant_enable" value="0"
                                   id="bkash_inactive" {{ $merchantStatus == '0' ? 'checked' : '' }}>
                            <label class="form-check-label" for="bkash_inactive">❌ Inactive</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bkash API Credentials -->
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-center">Bkash API Credentials</h6>
                </div>
                <div class="card-body">
                    <div class="form-group mt-2">
                        <label for="bkash_username">Bkash Username</label>
                        <input type="text" class="form-control" id="bkash_username" name="bkash_username"
                               value="{{ $bkashSettings['bkash_username'] ?? '' }}">
                    </div>

                    <div class="form-group mt-2">
                        <label for="bkash_password">Bkash Password</label>
                        <input type="text" class="form-control" id="bkash_password" name="bkash_password"
                               value="{{ $bkashSettings['bkash_password'] ?? '' }}">
                    </div>

                    <div class="form-group mt-2">
                        <label for="bkash_app_key">Bkash API Key</label>
                        <input type="text" class="form-control" id="bkash_app_key" name="bkash_app_key"
                               value="{{ $bkashSettings['bkash_app_key'] ?? '' }}">
                    </div>

                    <div class="form-group mt-2">
                        <label for="bkash_app_secret_key">Bkash Secure Key</label>
                        <input type="text" class="form-control" id="bkash_app_secret_key" name="bkash_app_secret_key"
                               value="{{ $bkashSettings['bkash_app_secret_key'] ?? '' }}">
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="d-flex justify-content-start mt-4">
                <button type="submit" class="btn btn-primary">Update Settings</button>
            </div>
        </form>
    </div>
@endsection
