@extends('admin.admin_dashboard')

@section('admin')
    <div class="page-content">
        <h1 class="h3 mb-2 text-gray-800">Complete Order <span
                class="badge bg-danger rounded-pill modern-badge">{{ count($paidOrders) }}</span></h1>

        @if (session('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

        <div class="table-responsive">
            <table id="dataTableExample" class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr class="align-middle">
                        <th>ID</th>
                        <th>Name</th>
                        <th>Date</th>
                        <th>Package</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Payment Gateway</th>
                        <th>Payment</th>
                        <th>Order Status</th>
                        <th>UID/Voucher</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($paidOrders as $order)
                        <tr>
                            <td>{{ $order->id }}</td>
                            <td>{{ $order->user->name }}</td>
                            <td>{{ $order->created_at->format('j M y, h:i A') }}</td>
                            <td>{{ Str::limit(optional($order->variation)->title, 19) }}</td>
                            <td>{{ $order->qty }}</td>
                            <td>৳{{ number_format($order->total_price, 2) }}</td>
                            <td>
                                <button class="btn btn-success btn-sm">{{ $order->payment_type }}</button>
                            </td>
                            <td>
                                <button class="btn btn-{{ (int) $order->status === 0 ? 'danger' : 'success' }} btn-sm">
                                    {{ (int) $order->status === 0 ? 'Pending Payment' : 'Paid' }}
                                </button>
                            </td>
                            <td>
                                @if ($order->auto_status == 2 || $order->status == 2)
                                    <button class="btn btn-success btn-sm">Complete</button>
                                @endif
                            </td>
                            <td>
                                @if ($order->type === 'voucher')
                                    {{ Log::info('Order ' . $order->id . ' Items: ' . ($order->items ? $order->items->toJson() : 'null')) }}
                                    @if ($order->items && $order->items->isNotEmpty())
                                        @php
                                            $voucherCodes = $order->items
                                                ->map(function ($item) {
                                                    return $item->voucher
                                                        ? Str::substr($item->voucher->code, -4)
                                                        : null;
                                                })
                                                ->filter()
                                                ->implode(', ');
                                        @endphp
                                        @if ($voucherCodes)
                                            <span class="text-muted">Voucher Assigned {{ $voucherCodes }}</span>
                                        @else
                                            <span class="text-warning">No Voucher Assigned</span>
                                        @endif
                                    @else
                                        <span class="text-warning">No Voucher Info</span>
                                    @endif
                                @elseif (!empty($order->player_id))
                                    {{ Str::limit($order->player_id, 10) }}
                                @else
                                    <span class="text-danger">Ingame Topup Edit Check Details</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.order.edit', $order->id) }}" class="btn btn-success btn-sm">
                                    <i class="fas fa-pen"></i>
                                </a>
                                <a href="{{ route('paid.order.delete', $order->id) }}" class="btn btn-danger btn-sm"
                                    id="delete">
                                    <i class="fas fa-trash"></i>
                                </a>
                                @if ($order->autoTopup)
                                    <a href="https://api.hidetopup.com/transactions/{{ $order->autoTopup->uid }}"
                                        target="_blank" class="btn btn-primary btn-sm">
                                        Check API
                                    </a>
                                @else
                                    <span class="text-muted">No API Data</span>
                                @endif
                            </td>
                            @if ($order->type === 'ingame')
                                <td>
                                    <button type="button" class="btn btn-info btn-sm" data-bs-toggle="popover"
                                        data-bs-trigger="focus"
                                        data-bs-content="
                                            Account Type: {{ $order->game_account_type }}
                                            Account: {{ $order->game_account }}
                                            Password: {{ $order->game_password }}
                                            Backup Code: {{ $order->game_backup }}">
                                        Details
                                    </button>
                                </td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            {{ $paidOrders->links() }}
        </div>
    </div>
@endsection
