@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">
    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800 text-center fw-bold">ORDER EDIT</h1>

    <!-- Card for displaying messages -->
    <div class="card shadow rounded mb-4">
        <div class="card-body">
            @if (session()->has('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger">{{ session('error') }}</div>
            @endif
        </div>
    </div>

    <!-- Order Details Section -->
    @if($order->type === 'ingame' && ($order->game_account || $order->game_password || $order->backup_code))
    <div class="card mb-4 shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Game Account Details</h5>
        </div>
        <div class="card-body">
            <div class="row g-3">
                @if($order->game_account_type)
                <div class="col-md-6">
                    <label class="form-label fw-bold">Game Account Type</label>
                    <input type="text" class="form-control" value="{{ $order->game_account_type }}" readonly>
                </div>
                @endif
                @if($order->game_account)
                <div class="col-md-6">
                    <label class="form-label fw-bold">Game Account</label>
                    <div class="input-group">
                        <input type="text" id="gameAccount" class="form-control" value="{{ $order->game_account }}" readonly>
                        <button type="button" class="btn btn-outline-secondary" onclick="copyToClipboard('gameAccount')">Copy</button>
                    </div>
                </div>
                @endif
                @if($order->game_password)
                <div class="col-md-6">
                    <label class="form-label fw-bold">Game Password</label>
                    <div class="input-group">
                        <input type="text" id="gamePassword" class="form-control" value="{{ $order->game_password }}" readonly>
                        <button type="button" class="btn btn-outline-secondary" onclick="copyToClipboard('gamePassword')">Copy</button>
                    </div>
                </div>
                @endif
                @if($order->game_backup)
                <div class="col-md-6">
                    <label class="form-label fw-bold">Backup Code</label>
                    <div class="input-group">
                        <input type="text" id="backupCode" class="form-control" value="{{ $order->game_backup }}" readonly>
                        <button type="button" class="btn btn-outline-secondary" onclick="copyToClipboard('backupCode')">Copy</button>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    @endif

    <!-- Form Section -->
    <div class="card shadow rounded">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">Update Order Status</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.order.update', $order->id) }}" method="post" enctype="multipart/form-data">
                @csrf
                @method('put')
                <div class="row g-3">
                    <div class="col-md-12">
                        <label class="form-label fw-bold">Status</label>
                        @if($order->automatic)
                        <select name="auto_status" class="form-select">
                            <option value="">Please select</option>
                            <option value="1" {{ $order->auto_status == '1' ? 'selected' : '' }}>PROCESSING</option>
                            <option value="2" {{ $order->auto_status == '2' ? 'selected' : '' }}>COMPLETED</option>
                            <option value="3" {{ $order->auto_status == '3' ? 'selected' : '' }}>CANCELLED</option>
                        </select>
                        <small class="text-danger">This is an automatic order. Updating auto status.</small>
                        @else
                        <select name="status" class="form-select">
                            <option value="">Please select</option>
                            <option value="0" {{ $order->status == '0' ? 'selected' : '' }}>PENDING</option>
                            <option value="1" {{ $order->status == '1' ? 'selected' : '' }}>PROCESSING</option>
                            <option value="2" {{ $order->status == '2' ? 'selected' : '' }}>COMPLETED</option>
                            <option value="3" {{ $order->status == '3' ? 'selected' : '' }}>CANCELLED</option>
                        </select>
                        <small class="text-danger">This is a manual order. Updating manual status.</small>
                        @endif
                        @error('status')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                        @error('auto_status')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-12">
                        <label class="form-label fw-bold">Notice</label>
                        <textarea class="form-control" name="notice">{{ $order->notice }}</textarea>
                        @error('notice')
                        <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="mt-4 text-end">
                    <button type="submit" class="btn btn-primary">UPDATE</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function copyToClipboard(elementId) {
        const element = document.getElementById(elementId);
        element.select();
        document.execCommand('copy');
        alert('Copied: ' + element.value);
    }
</script>

@endsection
