<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
class UserController extends Controller

{

    public function userLeaderboard()
{
    // Fetch top 10 users by completed orders in the current month
    $topUsers = DB::table('orders')
        ->join('users', 'orders.user_id', '=', 'users.id')
        ->select('users.name', 'orders.user_id', DB::raw('COUNT(orders.id) as total_orders'))
        ->where('orders.status', 2) // Only completed orders
        ->whereMonth('orders.created_at', Carbon::now()->month)
        ->whereYear('orders.created_at', Carbon::now()->year)
        ->groupBy('orders.user_id', 'users.name')
        ->orderByDesc('total_orders')
        ->limit(10)
        ->get();

        // return $topUsers;

    return view('user.leaderboard', compact('topUsers'));
} // End Method

}