<?php

namespace App\Http\Controllers\Admin;

use App\Models\Slider;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class SliderController extends Controller
{
 
    public function index()
    {
        $sliders = Slider::all();
        return view('admin.slider.index', compact('sliders'));
    }

    public function create()
    {
        return view('admin.slider.create');
    }

    public function store(Request $request)
{
    $request->validate([
        'link' => 'required|string|max:255',
        'image_url' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
    ]);

    $publicPath = public_path('upload/slider');

    // Create the directory if it doesn't exist
    if (!file_exists($publicPath)) {
        mkdir($publicPath, 0755, true);
    }

    $image = $request->file('image_url');
    $imageName = time() . '.' . $image->getClientOriginalExtension();
    $image->move($publicPath, $imageName);

    // Save the path including 'public'
    Slider::create([
        'link' => $request->input('link'),
        'image_url' => 'public/upload/slider/' . $imageName,
    ]);

    return redirect()->route('sliders.index')->with('success', 'Slider created successfully!');
}



    public function edit(Slider $slider)
    {
        return view('admin.slider.edit', compact('slider'));
    }

    public function update(Request $request, Slider $slider)
    {
        $request->validate([
            'link' => 'required|url',
            'image_url' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
    
        // Check if a new image is being uploaded
        if ($request->hasFile('image_url')) {
            // Delete the old image if it exists
            $oldImage = public_path($slider->image_url); // Get the path of the old image
            if (file_exists($oldImage)) {
                unlink($oldImage); // Remove the old image from the server
            }
    
            // Store the new image
            $image = $request->file('image_url');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $publicPath = public_path('upload/slider');
            $image->move($publicPath, $imageName);
    
            // Update the slider with the new image path
            $slider->update([
                'link' => $request->input('link'),
                'image_url' => 'public/upload/slider/' . $imageName,
            ]);
        } else {
            // If no new image is uploaded, only update the link
            $slider->update([
                'link' => $request->input('link'),
            ]);
        }
    
        return redirect()->route('sliders.index')->with('success', 'Slider updated successfully!');
    }


    public function destroy(Slider $slider)
    {
        // Get the relative path of the image stored in the 'image_url' column
        $imagePath = public_path('upload/slider/' . basename($slider->image_url));
    
        // Check if the image file exists and delete it
        if (file_exists($imagePath)) {
            unlink($imagePath); // This deletes the image file
        }
    
        // Delete the slider record from the database
        $slider->delete();
    
        return redirect()->route('sliders.index')->with('success', 'Slider deleted successfully!');
    }
    
}
