<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Models\Order;
use App\Models\AutoTopup;
use App\Models\Payment;
use App\Models\Voucher;
use App\Models\Vseed;
use Carbon\Carbon;
use Illuminate\Support\Str;

class oldtopup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:topup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command run for auto topup';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Log::info(str_repeat('-', 50)); // 50টি ড্যাশ
        Log::info('Starting AutoTopup');
        $this->checkStatus();
        $oldorders = Order::where('auto_status', 0)->whereNotNull('automatic')->where('created_at', '<=', Carbon::now()->subMinutes(60))->get();
        foreach ($oldorders as $oldorder) {
            $oldorder->auto_status = 3;
            $oldorder->save();
        }

        $orders = Order::where('auto_status', 0)->whereNotNull('automatic')->take(5)->get();

        foreach ($orders as $order) {
              // প্রতিটি অর্ডারের লগ শুরু করার আগে একটি ড্যাশ লাইনের ব্যবহারে স্পেস যোগ করা
              Log::info(str_repeat('-', 50)); // 50টি ড্যাশ
              Log::info('Processing Order ID: ' .  $order->id);
            if (isset($order)) {
                if ($order->payment_type == 'payment_gateway') {
                    $payment = Payment::where('order_id', $order->id)
                        ->where('payment_status', 'pending')
                        ->first();
                    if (isset($payment)) {
                        Log::info("Skipping Order ID {$order->id} due to pending payment.");
                          // প্রতিটি অর্ডারের লগ শুরু করার আগে একটি ড্যাশ লাইনের ব্যবহারে স্পেস যোগ করা
              Log::info(str_repeat('-', 50)); // 50টি ড্যাশ
                        continue; // Skip to the next order instead of exiting the loop
                    }
                }
            }

            if (!$order) {
                Log::warning("Order not found or invalid.");
    continue;
            }

            Log::info("Order ID {$order->id} is being processed.");

            $orderId = $order->id;
            $playerId = $order->player_id;
            $voucher = Voucher::find($order->voucher_id);

            Log::info('Player ID: ' . $playerId);
            Log::info('Voucher Details: ' . json_encode($voucher));

            $vseed = Vseed::where('name', $voucher->automatic)->first();

            if (Str::contains($voucher->code, 'BDMB-')) {
                $string = str_replace('BDMB-', '', $voucher->code);
                $type = '1';
            } else {
                $string = str_replace('UPBD-', '', $voucher->code);
                $type = '2';
            }

            switch ($vseed->denom) {
                case 0:
                    $denom = '0';
                    break;
                case 1:
                    $denom = '1';
                    break;
                case 2:
                    $denom = '2';
                    break;
                case 3:
                    $denom = '3';
                    break;
                case 4:
                    $denom = '4';
                    break;
                case 5:
                    $denom = '5';
                    break;
                case 6:
                    $denom = '6';
                    break;
                case 7:
                    $denom = '7';
                    break;
                case 8:
                    $denom = '8';
                    break;
                case 9:
                    $denom = '9';
                    break;
                case 10:
                    $denom = '10';
                    break;
                case 11:
                    $denom = '11';
                    break;
                case 12:
                    $denom = '12';
                    break;
                case 13:
                    $denom = '13';
                    break;
                case 14:
                    $denom = '14';
                    break;
                case 15:
                    $denom = '15';
                    break;
                default:
                    $denom = null; // Default value if none match
                    break;
            }

            // Prepare the payload for the POST request
            $payload = [
                'playerId' => $playerId,
                'denom' => $denom,
                'type' => $type,
                'voucherCode' => $string,
                'webhook' => 'https://webhook.site/9862ab15-eb9b-4e0f-be47-32f8fee359c5',
            ];

            // Log the payload being sent for debugging
            Log::info('Sending top-up request', $payload);

            // Send the POST request for top-up
            $response = Http::withHeaders([
                'RA-SECRET-KEY' => 'qk6Pn/6qjqwaSgc2JOh4nE1uQyiPjc1ffePqwPG0oAz1Y54iXddAkQ==',
                'Content-Type' => 'application/json',
            ])->post('https://api.prantopup.com/topup', $payload);

            // Log the response for debugging
            Log::info('Response received', ['response' => $response->json()]);

            // Check for response status
            if ($response->failed()) {
                $order->auto_status = '3';
                $order->save();
                Log::error("Failed to process top-up, Error: {$response->body()}");
                return; // Handle the error appropriately
            }

            // Process the response data
            $responseData = $response->json();
            if (isset($responseData['status']) && $responseData['status'] === true) {
                Log::info('Top-up successful', $responseData);

                // Store the top-up details in the auto_topup table
                $this->storeTopupDetails($orderId, $responseData['uid'], 'pending');
                $order->auto_status = '1';
                $order->save();

                // Now check the transaction status using the UID
                $transactionUid = $responseData['uid'];
            } else {
                Log::error('Top-up failed', $responseData);
            }
        }
    }

    private function storeTopupDetails($orderId, $uid, $status): void
    {
        AutoTopup::create([
            'order_id' => $orderId,
            'uid' => $uid,
            'status' => $status,
        ]);
          // প্রতিটি অর্ডারের লগ শুরু করার আগে একটি ড্যাশ লাইনের ব্যবহারে স্পেস যোগ করা
          Log::info(str_repeat('-', 50)); // 50টি ড্যাশ
        Log::info("Stored top-up details: Order ID {$orderId}, UID {$uid}, Status {$status}");
    }



public function checkStatus()
    {
        $autotopups = AutoTopup::where('status', 'pending')->get();

        foreach($autotopups as $autotopup){
            if (isset($autotopup)) {
                $response = Http::withHeaders([
                    'RA-SECRET-KEY' => 'qk6Pn/6qjqwaSgc2JOh4nE1uQyiPjc1ffePqwPG0oAz1Y54iXddAkQ==',
                    'Content-Type' => 'application/json',
                ])->get("https://api.prantopup.com/transactions/{$autotopup->uid}");
    
                $order = Order::find($autotopup->order_id);
    
                $transactionData = $response->json();
    
                if ($transactionData['status'] === 'failed') {

 Log::error("[UID {$autotopup->uid}] Transaction failed for Order ID {$autotopup->order_id}. Message: {$transactionData['message']}");
   // প্রতিটি অর্ডারের লগ শুরু করার আগে একটি ড্যাশ লাইনের ব্যবহারে স্পেস যোগ করা
   Log::info(str_repeat('-', 50)); // 50টি ড্যাশ


                    $order->auto_status = '3';
                    $autotopup->status = 'failed';
                    $autotopup->message = $transactionData['message'] ?? 'No message provided';
                    $autotopup->save();
                }
    
                if ($transactionData['status'] === 'success') {
                    $order->auto_status = '2';
                    $autotopup->status = 'success';
                }
                $autotopup->save();
                $order->save();
            }

        }
    }

    

    
}   







