<?php

use GuzzleHttp\Middleware;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BkashController;
use App\Http\Controllers\ClearController;
use App\Http\Controllers\UpdateController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\DrutopayController;
use App\Http\Controllers\user\UserController;
use App\Http\Controllers\admin\AdminController;
use App\Http\Controllers\admin\OrderController;
use App\Http\Controllers\GoogleLoginController;
use App\Http\Controllers\admin\SliderController;
use App\Http\Controllers\admin\ProfileController;
use App\Http\Controllers\admin\SettingController;
use App\Http\Controllers\admin\VoucherController;
use App\Http\Controllers\ForgotPasswordController;
use Illuminate\Support\Facades\Artisan;

Route::group(['namespace' => 'App\Http\Controllers'], function () {
    //Route::get('check', 'CheckController@check');
    Route::get('login', 'LoginController@login')->name('login');
    Route::post('login', 'LoginController@loginSubmit');
    Route::get('register', 'LoginController@register');
    Route::post('register', 'LoginController@registerStore');
    Route::get('/logout', 'LoginController@logout');



    Route::get('/bkash', [BkashController::class, 'payment'])->name('url-pay');
    Route::post('/bkash/create', [BkashController::class, 'createPayment'])->name('url-create');
    Route::get('/bkash/callback', [BkashController::class, 'callback'])->name('url-callback');




    Route::get('/check', 'CheckController@check');
    Route::get('topup/{slug}', 'WelcomeController@topup');
    Route::get('/clear', [ClearController::class, 'Clear'])->name('clear.cache');

    Route::get('auth/google', [GoogleLoginController::class, 'redirectToGoogle']);


    Route::get('uddoktapay/pay', 'UddoktapayController@pay');
    Route::get('uddoktapay/success', 'UddoktapayController@success');
    Route::get('uddoktapay/cancel', 'UddoktapayController@cancel');
    Route::get('uddoktapay/webhook', 'UddoktapayController@webhook');


    Route::get('drutopay/pay', 'DrutopayController@pay');
    Route::get('drutopay/success', 'DrutopayController@success');
    Route::get('drutopay/cancel', 'DrutopayController@cancel');




    Route::get('/update-system', [UpdateController::class, 'update'])->name('update.system');


});


Route::get('/schedule-run', function () {
    Artisan::call('schedule:run');
    return response()->json(['message' => 'Scheduler executed!']);
});




Route::get('forget-password', [ForgotPasswordController::class, 'showForgetPasswordForm'])->name('forget.password.get');

Route::post('forget-password', [ForgotPasswordController::class, 'submitForgetPasswordForm'])->name('forget.password.post');

Route::get('reset-password/{token}', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('reset.password.get');

Route::post('reset-password', [ForgotPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');


Route::get('callback/google', [GoogleLoginController::class, 'handleGoogleCallback']);


// Routes with the 'license' middleware
Route::middleware(['license'])->group(function () {
    Route::get('/', [WelcomeController::class, 'welcome'])->name('welcome');
});

Route::get('/leaderboard', [UserController::class, 'userLeaderboard'])->name('user.leaderboard');


// Admin Login Routes
Route::get('/admin/login', [AdminController::class, 'AdminLogin'])->name('admin.login');



Route::group(['middleware' => ['user', 'auth'], 'namespace' => 'App\Http\Controllers\user'], function () {
    //all payment controller
    Route::post('/process-payment', [PaymentController::class, 'processPayment'])->name('processPayment');
    Route::get('/success', [PaymentController::class, 'successPage'])->name('successPage');
    Route::get('/cancel', [PaymentController::class, 'cancel'])->name('greenpay.cancel');
});

Route::group(['middleware' => ['user', 'auth'], 'as' => 'user.', 'prefix' => 'user', 'namespace' => 'App\Http\Controllers\user'], function () {
    Route::get('dashboard', 'DashboardController@dashboard')->name('dashboard');

    Route::get('message', 'DashboardController@message');

    Route::get('fund', 'PageController@fund');
    Route::get('fund/sopno', 'PageController@fund2');
    Route::post('order', 'PageController@order');
    Route::get('orders', 'PageController@orderList');
    Route::get('voucher', 'PageController@voucherOrder');
    Route::get('transactions', 'PageController@transactions');
    Route::post('update', 'PageController@update');

});

Route::group(['middleware' => ['admin'], 'as' => 'admin.', 'prefix' => 'admin', 'namespace' => 'App\Http\Controllers\admin'], function () {

    Route::get('dashboard', 'DashboardController@dashboard')->name('dashboard');

    // all delete
    Route::get('variation/delete/{id}', 'VariationController@delete');
    Route::get('voucher/delete/{id}', 'VoucherController@delete');
    Route::get('product/delete/{id}', 'ProductController@delete');

    //for variation
    Route::get('variation/create/{id}', 'VariationController@create');
    Route::post('variation/store', 'VariationController@store');
    Route::get('variation/edit/{id}', 'VariationController@edit');
    Route::post('variation/update/{id}', 'VariationController@update');
    Route::get('variation/list', 'VariationController@list');
    Route::get('voucher/chose/{value}', 'VoucherController@newCreate');

    //for transaction
    Route::get('transaction', 'TransactionController@transaction');

    Route::resource('product', 'ProductController');
    Route::resource('voucher', 'VoucherController');
    Route::resource('order', 'OrderController');

    //for Paid Order Only
    Route::get('paid/order', 'OrderController@PaidOrder')->name('paid.order');

    //for prossesing Order Only
    Route::get('prossesing/order', 'OrderController@ProssesingOrder')->name('prossesing.order');


    Route::get('/pending/order', 'OrderController@PendingOrder')->name('pending.order');



    //for Cancel Order Only
    //Route::get('cancel/order', 'OrderController@PaidOrder')->name('cancel.order');

});

Route::post('admin/setting/update', [SettingController::class, 'AdminUpdate'])->name('admin.setting.update');

Route::prefix('admin')->middleware(['auth', 'admin'])->group(function () {

    Route::get('/users/{id}/wallet-history', [AdminController::class, 'userWalletHistory'])
    ->name('admin.users.wallet-history');

    Route::get('/user/block/{id}', [AdminController::class, 'blockUser'])->name('admin.blockUser');
    Route::get('/user/unblock/{id}', [AdminController::class, 'unblockUser'])->name('admin.unblockUser');



    // New route for available vouchers
    Route::get('available/vouchers', [VoucherController::class, 'available'])->name('available');

    Route::get('/setting', [SettingController::class, 'index'])->name('admin.setting.index');

    Route::get('/cron/jobs', [SettingController::class, 'CronJobs'])->name('cron.jobs');

    // Menu Setting
    Route::get('/menu/setting', [SettingController::class, 'MenuSetting'])->name('menu.setting');
    Route::post('/menus/{id}/update', [SettingController::class, 'update'])->name('menu.update');
    Route::get('/menus/{id}/edit', [SettingController::class, 'edit'])->name('menu.edit');
    Route::post('/admin/menus', [SettingController::class, 'store'])->name('menus.store');

    Route::delete('/menus/{id}', action: [SettingController::class, 'destroy'])->name('menu.delete');


    Route::get('/color/setting', [SettingController::class, 'ColorSetting'])->name('color.setting');
    Route::post('/color/setting/update', [SettingController::class, 'ColorSettingUpdate'])->name('color.setting.update');

    // Pages for setting 
    Route::get('pages', [SettingController::class, 'AdminPageindex'])->name('admin.pages.index');
    Route::get('pages/{id}/edit', [SettingController::class, 'PageEdit'])->name('admin.pages.edit');
    Route::post('/admin/pages', [SettingController::class, 'AdminUpdatePage'])->name('admin.pages.update');

    Route::get('/payment-gateways', [AdminController::class, 'showPaymentGateways'])->name('admin.payment_gateways.index');
    Route::post('/payment-gateways/update', [AdminController::class, 'updatePaymentGateways'])->name('pay.gateways.update');

    // Bkash Payment Gateway
    Route::get('/bkash/Merchant', [AdminController::class, 'showBkash'])->name('admin.payment_gateways.bkash');
    Route::post('/admin/toggle-bkash-status', [AdminController::class, 'toggleBkashStatus'])->name('admin.toggleBkashStatus');
    Route::post('/bkash-gateways/update', [AdminController::class, 'BkashGetwayUpdate'])->name('bkash.payment_gateways.update');
    Route::get('/admin/order/delete/{id}', [OrderController::class, 'DeletePaidOrders'])->name('paid.order.delete');
});




Route::get('/{slug}', [SettingController::class, 'show'])->name('page.show');

// Admin Slider 

Route::prefix('admin')->middleware(['auth', 'admin'])->group(function () {
    Route::resource('sliders', SliderController::class);

    // Profile update routes
    Route::get('profile', [ProfileController::class, 'ProfileEdit'])->name('profile.edit');
    Route::post('profile/update', [ProfileController::class, 'AdminProfileUpdate'])->name('admin.profile.update');


    // Admin routes in AdminController
    Route::get('/users', [AdminController::class, 'users'])->name('admin.users');
    Route::get('/logout', [AdminController::class, 'AdminLogout'])->name('admin.logout');
    Route::get('/profile', [AdminController::class, 'AdminProfile'])->name('admin.profile');
    Route::post('/profile/store', [AdminController::class, 'AdminProfileStore'])->name('admin.profile.store');
    Route::get('/change/password', [AdminController::class, 'AdminChangePassword'])->name('admin.change.password');
    Route::post('/update/password', [AdminController::class, 'AdminUpdatePassword'])->name('admin.update.password');
    // User routes in UserController
    Route::get('users', [AdminController::class, 'usersList'])->name('users.list');
    //Route::post('/admin/update-balance', [AdminController::class, 'updateBalance'])->name('admin.update.balance');
    Route::post('admin/update-balance', [AdminController::class, 'updateBalance'])->name('admin.update.balance');
    Route::post('admin/update-user', [AdminController::class, 'updateUserDetails'])->name('admin.update-user');
    Route::post('admin/reset-password', [AdminController::class, 'resetPassword'])->name('admin.reset-password');



});




