@extends('frontend.master')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12 text-center my-4">
            <h2 class="text-primary fw-bold">My Transactions</h2>
            <hr>
        </div>
    </div>

    <div class="col-lg-9 col-md-10 mx-auto">
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Payment Method</th>
                                <th>Transaction</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($payments as $payment)
                            <tr>
                                <td>{{ \Carbon\Carbon::parse($payment->created_at)->format('d M y, h:i A') }}</td>
                                <td>৳{{ number_format($payment->amount, 2) }}</td>
                                <td>
                                    @if (!empty($payment->payment_type))
                                        <span class="badge bg-danger">{{ $payment->payment_type }}</span>
                                    @else
                                        <span class="badge bg-success">Payment Getway</span>
                                    @endif
                                </td>
                                <td>{{ $payment->transaction_id }}</td>
                                <td>
                                    @if ($payment->payment_status == 'completed')
                                        <span class="badge bg-success">Completed</span>
                                    @elseif ($payment->payment_status == 'pending')
                                        <span class="badge bg-warning text-dark">Pending</span>
                                    @else
                                        <span class="badge bg-danger">Failed</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center">No transactions found to show.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!-- Pagination Links -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $payments->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Sticky Footer Menu -->
@php
$menus = App\Models\Menu::all();
@endphp

<div class="sticky-footer-container">
    @foreach ($menus as $menu)
        <div class="sticky-footer-item">
            <a href="{{ $menu->link }}">
                <div class="d-flex justify-content-center align-items-center flex-column">
                    <span>{!! $menu->icon !!}</span>
                    <span class="fw-bold">{{ $menu->name }}</span>
                </div>
            </a>
        </div>
    @endforeach
</div>
@endsection