@extends('frontend.master')
@section('content')
<div class="container">
    <div class="panel simple_form shadow">
        <div class="panel_head">
            <h1 class="text-white">{{ $page->title }}</h1>
        </div>
        <div class="body">
            <p>{!! $page->content !!}</p>
        </div>
    </div>
</div>

    @php
    $menus = App\Models\Menu::all();
    @endphp
    
    
    
        <div class="sticky-footer-container">
            @foreach ($menus as $menu)
                <div class="sticky-footer-item">
                    <a href="{{ $menu->link }}">
                        <div class="d-flex justify-content-center align-items-center flex-column">
                            <span>{!! $menu->icon !!}</span> 
                            <span>{{ $menu->name }}</span>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
      
    @endsection
    
    @section('js')
   
    </script>
    
    
    <script>
        $(document).ready(function() {
            $('#accountButton').click(function() {
                $('.right-side-menu').toggleClass('active');
                $('#overlay').toggle();
            });
    
            $('#closeButton').click(function() {
                $('.right-side-menu').removeClass('active');
                $('#overlay').hide();
            });
    
            $('#overlay').click(function() {
                $('.right-side-menu').removeClass('active');
                $('#overlay').hide();
            });
        });
    </script>
    
    
    
    @endsection
    