@php
    $settings = App\Models\Setting::pluck('value', 'key')->toArray();
@endphp

<style>
    .social_media a {
        margin: 0 10px;
        /* Space between social icons */
        color: {{ $settings['social_media_color'] ?? '#d4e6f9' }};
        /* Dynamic icon color */
        font-size: 24px;
        /* Icon size */
    }

    .footer_info {
        background-color: {{ $settings['footer_info'] ?? '#000000' }};
        /* Fallback color */
        padding: 30px 15px;
        /* More padding for spacing */
        border-top: 1px solid #dee2e6;
        /* Subtle top border */
    }

    .content_heading {
        font-weight: bold;
        color: {{ $settings['content_heading_color'] ?? '#ffffff' }};
        /* Dynamic color */
        margin-bottom: 15px;
        /* Space below headings */
    }

    .support-box:hover,
    .support-box:active,
    .support-box:focus {
        border-color: rgba(255, 255, 255, 0.6);
    }

    .support-box {
        border-radius: 5px !important;
        overflow: hidden;
        border: 1px solid rgba(255, 255, 255, 0.3);
        padding: 5px 20px;
        margin-bottom: 20px;
        text-align: left;
    }

    .support-table .support-info {
        padding-left: 12px;
        /* Shifted phone number slightly to the left */
    }

    .support-table .support-info .sub-heading {
        font-size: 12px;
        opacity: 0.8;
        padding: 2px 0px 0px 0px;
    }

    .support-table .support-info .phone-number {
        font-size: 18px;
        font-weight: 500;
        padding: 2px 0px;
    }

    .support-table .support-icon {
        border-right: 1px solid rgba(255, 255, 255, 0.3);
        width: 45px;
        text-align: center;
        /* Center the icon inside the cell */
    }

    .support-table .support-icon i {
        font-size: 24px;
        padding: 5px;
    }

    .support-table {
        width: 100%;
        height: 100%;
    }

    /* Adjustments for desktop */
    @media (min-width: 992px) {
        .support-box {
            padding: 10px 20px;
            /* More spacious padding for desktop */
        }

        .support-table .support-info {
            padding-left: 10px;
            /* Reduced padding for better alignment on desktop */
        }

        .support-table .support-icon {
            width: 50px;
            /* Increased width for icon on desktop */
        }

        .support-table .support-icon i {
            font-size: 26px;
            /* Slightly larger icon */
        }
    }

    /* Adjustments for mobile */
    @media (max-width: 767px) {
        .support-box {
            padding: 5px 15px;
            /* Less padding for mobile screens */
        }

        .support-table .support-info {
            padding-left: 5px;
            /* Less padding on mobile */
        }
    }

    .footer-rights {
        padding: 15px 0;
        color: {{ $settings['footer_rights_color'] ?? '#f40000' }};
        /* Dynamic light text color */
    }
</style>



<div class="row footer footer_info">
    <!-- First Column: Stay Connected -->
    <div class="col-sm-4 text-center">
        <h4 class="content_heading text-white">STAY CONNECTED</h4>
        <h6>কোন সমস্যায় পড়লে হোয়াটসঅ্যাপ এ যোগাযোগ করবেন। তাহলে দ্রুত সমাধান পেয়ে যাবেন।</h6>
        <div class="social_media">
            <a href="{{ $settings['facebook_url'] }}" target="_blank">
                <i class="fab fa-facebook-f"></i>
            </a>
            <a href="{{ $settings['youtube_url'] }}" target="_blank">
                <i class="fab fa-youtube"></i>
            </a>
            <a href="mailto:{{ $settings['footer_email'] }}">
                <i class="fas fa-envelope"></i>
            </a>

        </div>
    </div>

    <!-- Second Column: Our Mobile App -->
    <div class="col-sm-4">
        <h4 class="content_heading text-white">Our Mobile App</h4>
        <a href="http://gstopup.com/" target="_blank">
            <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg"
                alt="Download on Google Play" class="img-fluid">
        </a>
    </div>

    <!-- Third Column: Support Center -->
    <div class="col-sm-4">
        <h4 class="content_heading text-white">Support Center</h4>
        <a href="https://wa.me/{{ $settings['support_phone'] ?? '' }}" class="support-link">
            <div class="support-box">
                <table class="support-table">
                    <tr>
                        <td class="support-icon">
                            <i class="fab fa-whatsapp"></i>
                        </td>
                        <td class="support-info">
                            <div class="sub-heading">হোয়াটসঅ্যাপ সাপোর্ট</div>
                            <div class="phone-number">{{ $settings['support_phone'] ?? 'N/A' }}</div>
                        </td>
                    </tr>
                </table>
            </div>
        </a>

        <a href="{{ $settings['telegram_support'] ?? '' }}" class="support-link">
            <div class="support-box">
                <table class="support-table">
                    <tr>
                        <td class="support-icon">
                            <i class="fab fa-telegram"></i>
                        </td>
                        <td class="support-info">
                            <div class="sub-heading">11:00AM - 09.00PM</div>
                            <div class="phone-number">টেলিগ্রামে সাপোর্ট</div>
                        </td>
                    </tr>
                </table>
            </div>
        </a>
    </div>

    <div class="text-center">
        {{ $settings['footer_copyright'] ?? 'N/A' }} Developed By <a
            href="https://web.whatsapp.com/send?phone=8801716720487&text=ineedgametopup-site"><span class="text-info">Web Devs</span></a>
    </div>
<br/> <br/> <br/> <br/>  <br/>
</div>



<!-- Load Custom JavaScript --

@if ($settings['chat_enabled'] ?? 0)
{!! $settings['custom_js'] !!}
@endif
