@extends('frontend.master')
@section('content')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

    <style>
        .order-guard-box {
            display: flex;
            justify-content: space-between;
            background: #f9f9f9;
            padding: 15px;
            border-radius: 10px;
            border: 2px solid #ddd;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            max-width: 100%;
            margin: auto;
        }

        .left-column,
        .right-column {
            width: auto;
        }

        .info {
            font-size: 14px;
            font-weight: normal;
            /* Fixed syntax */
            margin-bottom: 5px;
        }

        .voucher-list {
            background: #f0f0f0;
            padding: 2px;
            border-radius: 5px;
            list-style: none;
            border: 1px solid #ccc;
            max-width: 100%;
            padding-left: 8px;
            margin-bottom: 10px;
        }

        .copy-btn {
            padding: 8px 12px;
            font-size: 14px;
            background: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-bottom: 15px;
            margin-top: 5px;
            border-bottom: 2px solid #218838;
        }

        .copy-btn:hover {
            background: #218838;
        }

        .copy-btn.copied {
            background: #00b4ff;
            border-bottom: 2px solid #0094cc;
        }

        .copy-notification {
            position: fixed;
            right: 20px;
            bottom: 60px;
            background: #ff9000;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            display: none;
            z-index: 1000;
            max-width: 100%;
            font-weight: bold;
            animation: fadeIn 0.3s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .voucher-code {
            display: block;
            background: #f0f0f0;
            padding: 5px;
            border-radius: 4px;
            margin-bottom: 5px;
            font-family: monospace;
            font-size: 12px;
            border: 1px solid #ddd;
        }

        .order-box {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 10px;
            border: 2px solid #ddd;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .order-box .header {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }

        .badge {
            display: inline-block;
            padding: 0.25em 0.4em;
            font-size: 75%;
            font-weight: 700;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: 0.25rem;
            color: white;
        }

        .bg-primary {
            background-color: #007bff;
        }

        .bg-success {
            background-color: #28a745;
        }

        .bg-danger {
            background-color: #dc3545;
        }

        @media (max-width: 768px) {
            .order-guard-box {
                flex-direction: column;
            }
        }

        @media (max-width: 480px) {
            .order-guard-box {
                padding: 10px;
            }

            .copy-btn {
                width: 100%;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="col-sm-9 mx-auto p-tb-0">
            <center>
                <a href="https://shop.garena.my/app/100067/idlogin" target="_blank">
                    <button type="button" class="btn btn-aght theme-btn-block">REDEEM CODE</button>
                </a>
            </center>
            <div class="p-tb-20">
                <form method="get" style="display: flex; align-items: center; width: 100%;">
                    <div style="display: flex; align-items: center; width: 100%;">
                        <select name="status" id="status" class="searchstatus clickable-status">
                            <option value="" selected="">ALL</option>
                            <option value="completed">COMPLETED</option>
                            <option value="processing">PROCESSING</option>
                            <option value="auto-processing">AUTO-PROCESSING</option>
                            <option value="hold">HOLD</option>
                            <option value="pending">PENDING</option>
                            <option value="cancelled">CANCELLED</option>
                        </select>
                        <input type="text" name="title" value="" class="searchbox shadow"
                            placeholder="Search orders...">
                    </div>
                    <button type="submit" class="btn theme-btn shadow" style="height: 40px;">Search</button>
                </form>
            </div>
            <div class="content-box-no-padding shadow" style="margin: 0px;padding: 0px;">
                <div class="content-title-ms">My Orders</div>

                @foreach ($orders as $order)
                    @php
                        $product = App\Models\Product::find($order->product_id);
                        $variation = App\Models\Variation::find($order->variation_id);
                        // OrderItem থেকে ভাউচার আইডি নিয়ে আসা
                        $orderItems = $order->items;
                        $allVoucherIds = [];
                        $allVoucherCodes = [];
                        if ($orderItems && $orderItems->isNotEmpty()) {
                            foreach ($orderItems as $item) {
                                if ($item->voucher_id) {
                                    $allVoucherIds[] = $item->voucher_id; // Single integer ID
                                    $voucher = App\Models\Voucher::find($item->voucher_id);
                                    if ($voucher) {
                                        $allVoucherCodes[] = $voucher->code; // Use raw code without modification
                                    }
                                }
                            }
                        }
                        // সব কোড একসাথে জমা করা (লাইন বাই লাইন কপির জন্য)
                        $copyText = implode("\n", $allVoucherCodes);
                    @endphp

                    <!-- Mobile View -->
                    <div class="order-box d-block d-md-none">
                        <div class="header"><strong>Order No:</strong> {{ $order->id }}</div>
                        <div class="info"><strong>Date:</strong> {{ $order->created_at->format('d-m-Y') }}</div>
                        <div class="info"><strong>Product:</strong> {{ $product->title ?? 'N/A' }}</div>
                        <div class="info"><strong>Package:</strong> {{ $variation->title ?? 'N/A' }}</div>
                        <div class="info"><strong>Price:</strong> ৳{{ number_format($order->total_price, 2) ?? 'N/A' }}
                        </div>
                        <div class="info"><strong>Payment:</strong> {{ $order->payment_type ?? 'Not Found' }}</div>
                        <div class="info"><strong>Status:</strong>
                            <span
                                class="badge {{ $order->status == '2' ? 'bg-success' : ($order->status == '1' ? 'bg-primary' : 'bg-danger') }}">
                                @switch($order->status)
                                    @case('0')
                                        PENDING
                                    @break

                                    @case('1')
                                        PROCESSING
                                    @break

                                    @case('2')
                                        COMPLETED
                                    @break

                                    @case('3')
                                        CANCELLED
                                    @break
                                @endswitch
                            </span>
                        </div>

                        @if ($order->type == 'voucher' && $order->status == '2')
                            @if (!empty($allVoucherIds))
                                <div class="header"><strong>Your Codes:</strong></div>
                                <div class="voucher-list">
                                    @foreach ($allVoucherIds as $index => $voucherId)
                                        @php
                                            $voucher = App\Models\Voucher::find($voucherId);
                                        @endphp
                                        @if ($voucher)
                                            <div class="voucher-code">{{ $voucher->code }}</div>
                                        @endif
                                    @endforeach
                                </div>
                                <button class="copy-btn vouchercopy" data-voucher="{{ $copyText }}">
                                    <i class="fas fa-copy"></i> Copy All Codes
                                </button>
                            @else
                                <div class="info">No vouchers available</div>
                            @endif
                        @else
                            <div class="info">N/A</div>
                        @endif
                    </div>

                    <!-- Desktop View -->
                    <div class="order-guard-box d-none d-md-flex">
                        <div class="left-column">
                            <div class="info"><strong>Order No:</strong> {{ $order->id }}</div>
                            <div class="info"><strong>Date:</strong> {{ $order->created_at->format('d-m-Y') }}</div>
                            <div class="info"><strong>Product:</strong> {{ $product->title ?? 'N/A' }}</div>
                            <div class="info"><strong>Package:</strong> {{ $variation->title ?? 'N/A' }}</div>
                        </div>
                        <div class="right-column">
                            <div class="info"><strong>Price:</strong>
                                ৳{{ number_format($order->total_price, 2) ?? 'N/A' }}</div>
                            <div class="info"><strong>Payment:</strong> {{ $order->payment_type ?? 'Not Found' }}</div>
                            <div class="info"><strong>Status:</strong>
                                <span
                                    class="badge {{ $order->status == '2' ? 'bg-success' : ($order->status == '1' ? 'bg-primary' : 'bg-danger') }}">
                                    @switch($order->status)
                                        @case('0')
                                            PENDING
                                        @break

                                        @case('1')
                                            PROCESSING
                                        @break

                                        @case('2')
                                            COMPLETED
                                        @break

                                        @case('3')
                                            CANCELLED
                                        @break
                                    @endswitch
                                </span>
                            </div>

                            @if ($order->type == 'voucher' && $order->status == '2')
                                @if (!empty($allVoucherIds))
                                    <div class="info"><strong>Your Codes:</strong></div>
                                    <div class="voucher-list">
                                        @foreach ($allVoucherIds as $index => $voucherId)
                                            @php
                                                $voucher = App\Models\Voucher::find($voucherId);
                                            @endphp
                                            @if ($voucher)
                                                <div class="voucher-code">{{ $voucher->code }}</div>
                                            @endif
                                        @endforeach
                                    </div>
                                    <button class="copy-btn vouchercopy" data-voucher="{{ $copyText }}">
                                        <i class="fas fa-copy"></i> Copy All Codes
                                    </button>
                                @else
                                    <div class="info">No vouchers available</div>
                                @endif
                            @else
                                <div class="info">N/A</div>
                            @endif
                        </div>
                    </div>
                @endforeach

                {{ $orders->links() }}
            </div>
        </div>
    </div>

    @php
        $menus = App\Models\Menu::all();
    @endphp

    <div class="sticky-footer-container">
        @foreach ($menus as $menu)
            <div class="sticky-footer-item">
                <a href="{{ $menu->link }}">
                    <div class="d-flex justify-content-center align-items-center flex-column">
                        <span>{!! $menu->icon !!}</span>
                        <span>{{ $menu->name }}</span>
                    </div>
                </a>
            </div>
        @endforeach
    </div>

    <div class="copy-notification">Voucher codes copied!</div>

    <script>
        $(document).ready(function() {
            $('.vouchercopy').on('click', function() {
                var voucherCodes = $(this).data('voucher');
                var $button = $(this);

                navigator.clipboard.writeText(voucherCodes).then(function() {
                    // Visual feedback on button
                    $button.addClass('copied');
                    $button.html('<i class="fas fa-check"></i> Copied!');

                    // Show notification
                    $('.copy-notification').fadeIn(300);

                    // Reset button after 2 seconds
                    setTimeout(function() {
                        $button.removeClass('copied');
                        $button.html('<i class="fas fa-copy"></i> Copy All Codes');
                        $('.copy-notification').fadeOut(300);
                    }, 2000);
                }, function(err) {
                    console.error('Could not copy text: ', err);
                    alert('Could not copy voucher codes. Please try again.');
                });
            });
        });
    </script>

@endsection
