@extends('frontend.master')
@section('content')

    <div class="container-fluid">

       

        <div class="col-sm-9 mx-auto p-tb-20">

      
            <div class="p-tb-20">
                <form method="get" style="display: flex; align-items: center; width: 100%;">
                    <div style="display: flex; align-items: center; width: 100%;">
                        <select name="status" id="status" class="searchstatus clickable-status">
                            <option value="" selected="">ALL</option>
                            <option value="completed">COMPLETED</option>
                            <option value="processing">PROCESSING</option>
                            <option value="auto-processing">AUTO-PROCESSING</option>
                            <option value="hold">HOLD</option>
                            <option value="pending">PENDING</option>
                            <option value="cancelled">CANCELLED</option>
                        </select>
                        <input type="text" name="title" value="" class="searchbox shadow"
                            placeholder="Search orders...">
                    </div>
                    <button type="submit" class="btn theme-btn shadow" style="height: 40px;">
                        Search
                    </button>
                </form>
            </div>
            <div class="content-box-no-padding shadow" style="margin: 0px;padding: 0px;">
                <div class="content-title-ms">
                    My Orders
                </div>
                <table
                    class="content-box-no-padding-table table table-striped table-mobile-responsive table-mobile-sided fully-responsive-table"
                    style="margin: 0px;" width="100%">
                    <thead>
                        <tr class="align-middle">
                            <th scope="col" style="border-radius: 12px 0px 0px 0px !important;">Id</th>
                            <th scope="col">Date</th>
                            <th scope="col">Product</th>
                            <th scope="col">Package</th>
                            <th scope="col">Price</th>
                            <th scope="col">Notice</th>
                            <th scope="col">Payment Type</th>
                            <th scope="col">Topup Uid</th>
                            <th scope="col" style=" border-radius: 0px 12px 0px 0px !important; padding-right: 10px;">
                                Status
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($orders as $order)
                            <tr class="info_list align-middle" id="refresh_79">
                                @php
                                    $product = App\Models\Product::find($order->product_id);
                                    $variation = App\Models\Variation::find($order->variation_id);
                                @endphp
                                <td scope="row" data-content="Id">{{ $order->id }}</td>
                                <td data-content="Date">{{ $order->created_at->format('d-m-Y') }}</td>
                                <td data-content="Product">{{ isset($product) ? $product->title : '' }}</td>
                                <td data-content="Package">{{ isset($variation) ? $variation->title : '' }}</td>
                                <td data-content="Price">৳{{ isset($variation) ? $variation->price : '' }}</td>
                                <td data-content="Notice" class="delivery_message">{{ $order->notice }}</td>
                                <td>{{ $order->payment_type ?? 'Not Found'}}</td>
                                <td>
                                    @if ($order->type == 'voucher' && $order->status == '2')
                                        @php
                                            $voucher = App\Models\Voucher::find($order->voucher_id);
                                        @endphp
                                        @if (isset($voucher))
                                            <button type="button" class="btn theme-btn shadow vouchercopy"
                                                data-voucher="{{($voucher->code) }}">
                                                Copy
                                            </button>


                                            {{-- <button type="button" class="btn theme-btn shadow vouchercopy"
                                            data-voucher="{{ Crypt::decryptString($voucher->code) }}">
                                            Copy
                                        </button> --}}

                                        @endif
                                    @else
                                        {{ $order->player_id }}
                                    @endif
                                </td>
                                <td>
    @if ($order->auto_status == 1)
        <span class="badge bg-primary">Auto Processing</span>
    @elseif ($order->auto_status == 2)
        <span class="badge bg-success">Complete</span>
    @elseif ($order->auto_status == 3)
        <span class="badge bg-danger">Canceled</span>
    @else
        @if ($order->status == 1)
            <span class="badge bg-info">Processing</span>

        @elseif ($order->status == 2)
            <span class="badge bg-success">Complete</span>   
        @elseif ($order->status == 3)
            <span class="badge bg-danger">Canceled</span>
        @else
            <span class="badge bg-danger">Payment Pending</span>
        @endif
    @endif
</td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>

                {{ $orders->links() }}
            </div>
        </div>
    </div>

  
    @php
    $menus = App\Models\Menu::all();
    @endphp
    
    
    
        <div class="sticky-footer-container">
            @foreach ($menus as $menu)
                <div class="sticky-footer-item">
                    <a href="{{ $menu->link }}">
                        <div class="d-flex justify-content-center align-items-center flex-column">
                            <span>{!! $menu->icon !!}</span> 
                            <span>{{ $menu->name }}</span>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>
      


@endsection


