@extends('frontend.master')
@section('content')
    @php
        // Define the settings keys that you want to use in the welcome page
        $settingsKeys = [
            'site_title',
            'site_name',
            'meta_description',
            'meta_keywords',
            'og_image',
            'twitter_image',
            'favicon',
            'support_phone',
            'youtube_url',
            'notice_board',
            'messenger_url',
            'youtube_video',
            'PopupText',
            'logo',
            
        ];
        // Fetch these settings from the database
        $settings = App\Models\Setting::whereIn('key', $settingsKeys)->pluck('value', 'key');

    @endphp


    <style>
        /* Container for the heading */
        .heading {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
            position: relative;
        }

        /* Stylish line */
        .line {
            flex: 1;
            height: 2px;
            background: linear-gradient(45deg, #ff8a00, #e52e71);
            /* Gradient for a sleek look */
            border-radius: 5px;
            position: relative;
            animation: lineAnimation 1.5s ease-in-out infinite;
        }

        /* Diamond shapes */
        .diamond {
            width: 20px;
            height: 20px;
            background: #e52e71;
            transform: rotate(45deg);
            position: relative;
            animation: diamondAnimation 2s ease-in-out infinite;
        }

        /* Text style */
        .heading span {
            font-weight: bold;
            font-size: 1.5rem;
            color: #e52e71;
            /* Vibrant color for text */
            padding: 0 15px;
            position: relative;
            z-index: 1;
            letter-spacing: 1px;
            text-transform: uppercase;
            font-family: 'Roboto', sans-serif;
            animation: textAnimation 2s ease-in-out infinite;
            background: linear-gradient(45deg, #ff8a00, #e52e71);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        /* Line animation */
        @keyframes lineAnimation {
            0% {
                transform: scaleX(1);
            }

            50% {
                transform: scaleX(1.1);
            }

            100% {
                transform: scaleX(1);
            }
        }

        /* Diamond animation */
        @keyframes diamondAnimation {
            0% {
                transform: rotate(45deg) scale(1);
            }

            50% {
                transform: rotate(45deg) scale(1.2);
            }

            100% {
                transform: rotate(45deg) scale(1);
            }
        }

        /* Text animation (subtle pop effect) */
        @keyframes textAnimation {
            0% {
                opacity: 0;
                transform: translateY(10px);
            }

            50% {
                opacity: 1;
                transform: translateY(0);
            }

            100% {
                opacity: 0;
                transform: translateY(-10px);
            }
        }

        .border-container {
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .social-link {
            background-color: #f8f9fa;
            border: 1px solid #e0e0e0;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease;
            text-decoration: none;
            color: #333;
        }

        .social-link:hover {
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
            color: #333;
        }

        .social-icon {
            font-size: 35px;
        }

        /* Container for product */
        .product {
            position: relative;
            text-align: center;
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            animation: fadeIn 1s ease-in-out;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 2px;
            background: #fff;
        }

        /* Scale and shadow effect on hover */
        .product:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        /* Animation for entry effect */
        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }

            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Styling for product image */
        .product img {
            width: 100%;
            height: auto;
            border-radius: 8px;
            transition: transform 0.3s ease;
        }

        /* Slight zoom-in effect on hover */
        .product:hover img {
            transform: scale(1.1);
        }



        /* Slide-in animation for the title */
        @keyframes slideUp {
            0% {
                transform: translateY(30px);
                opacity: 0;
            }

            100% {
                transform: translateY(0);
                opacity: 1;
            }
        }
    </style>


    <div class="notice-container">
        <div class="alert alert-light notice-style alert-dismissible fade show position-relative" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <div class="notice-heading"></div>
            <div class="notice-text mb-0">


                <marquee style="color:white"> {{ $settings['notice_board'] ?? 'csscsc' }} </marquee>

            </div>
        </div>
    </div>

    @php
        $sliders = App\Models\Slider::all();
    @endphp

    <div id="slider" class="carousel slide carousel-zoom" data-bs-ride="carousel">
        <div class="carousel-inner">
            @foreach ($sliders as $key => $slider)
                <div class="carousel-item {{ $key === 0 ? 'active' : '' }}">
                    <a href="{{ url($slider->link) }}">


                        <img src="{{ url('/') . '/' . $slider->image_url }}" class="d-block w-100 size-effect"
                            alt="Slider Image">
                    </a>
                </div>
            @endforeach
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#slider" data-bs-slide="prev">
            <i class="fa-solid fa-angle-left slider-icon" aria-hidden="true"></i>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#slider" data-bs-slide="next">
            <i class="fa-solid fa-angle-right slider-icon" aria-hidden="true"></i>
        </button>
    </div>








    <div class="product_list" id="topup">
        <div class="heading">
            <div class="line"></div>
            <div class="diamond"></div>
            <span>Game TOPUP</span>
            <div class="diamond"></div>
            <div class="line"></div>
        </div>

        @if ($products->isNotEmpty())
            <div class="row gx-2 gy-3">
                @foreach ($products as $product)
                    <div class="col-4 col-sm-2">
                        <a href="{{ url('topup', $product->slug) }}">
                            <div class="product">
                                <img src="{{ url('/') . '/' . $product->image }}" alt="{{ $product->title }}">
                                <div class="product_title">
                                    {{ $product->title }}
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-center text-danger">No products found.</p>
        @endif
    </div>

    </div>

    @php
    $orders = App\Models\Order::with(['user', 'variation'])
                ->latest()
                ->take(5)
                ->get();
@endphp


<div class="container my-5">
    <div class="text-center mb-4">
      <h3 class="fw-bold fs-4 fs-lg-1">Latest 5 Orders</h3>
      <p class="d-none">সর্বশেষ আপডেট করা হয়েছে <span class="fs-6 fw-bold text-primary">কয়েক সেকেন্ড আগে</span></p>
    </div>
  
    @if(isset($orders) && $orders->isNotEmpty())
      <div class="list-group">
        @foreach($orders as $order)
  
          @php
              // User Profile Image (Random Avatar Generator)
              $profileImage = $order->user->profile_photo_url ?? null;
              if (!$profileImage) {
                  $randomAvatar = [
                      "https://ui-avatars.com/api/?name=" . urlencode($order->user->name ?? 'User'),
                      "https://picsum.photos/seed/" . rand(1000, 9999) . "/40/40"
                  ];
                  $profileImage = $randomAvatar[array_rand($randomAvatar)];
              }
  
              // Show Only Variation Title
              $variationTitle = isset($order->variation) ? $order->variation->title : 'Unknown Variation';
          @endphp
  
          <div class="list-group-item d-flex align-items-center p-4 mb-3 rounded-3 shadow-sm">
            <!-- Profile Image -->
            <img src="{{ $profileImage }}" class="rounded-circle me-3" style="width: 40px; height: 40px;" alt="user">
            
            <div class="flex-grow-1">
              <div class="fw-medium">{{ $order->user->name ?? 'Unknown User' }}</div>
              <div class="text-muted small">
                {{ $variationTitle }} - {{ number_format($order->total_price, 2) }} ৳
              </div>
            </div>
  
            <span class="badge rounded-pill text-bg-{{ $order->status == '1' ? 'info' : 'success' }} px-3 py-1">
              {{ $order->status == '0' ? 'RUNNING' : 'COMPLETED' }}
            </span>
          </div>
  
        @endforeach
      </div>
    @else
      <p class="text-center text-danger">No orders found.</p>
    @endif
  </div>
  
  <br>
  
  
  <br>


    <div class="container my-5">
        <div class="border-container p-4">
            <h2 class="text-center mb-4">We Love? Follow Us</h2>

            <div class="row justify-content-center">
                <div class="col-md-4 mb-3">
                    <a href="{{ $settings['messenger_url'] }}" target="_blank"
                        class="social-link d-flex align-items-center p-3 rounded">
                        <i class="fab fa-facebook-f me-3 social-icon" style="color: #3b5998;"></i>
                        <span>যেকোন সমস্যায় সরাসরি আমাদের ফেসবুক পেজ এ মেসেজ দিন ।</span>
                    </a>
                </div>
                <div class="col-md-4 mb-3">
                    <a href="https://wa.me/{{ $settings['support_phone'] }}" target="_blank"
                        class="social-link d-flex align-items-center p-3 rounded">
                        <i class="fab fa-whatsapp me-3 social-icon" style="color: #25D366;"></i>
                        <span>যেকোন সমস্যায় সরাসরি আমাদের Whatsapp এ মেসেজ দিন ।</span>
                    </a>
                </div>
                <div class="col-md-4 mb-3">
                    <a href="{{ $settings['youtube_video'] }}" target="_blank"
                        class="social-link d-flex align-items-center p-3 rounded">
                        <i class="fab fa-youtube me-3 social-icon" style="color: #FF0000;"></i>
                        <span>কিভাবে অর্ডার করবেন? সেটি জানতে এই ভিডিওটি দেখুন ।</span>
                    </a>
                </div>
            </div>
        </div>
    </div>




    <br>
    <br>







    @if ($showPopup)
        <div id="popup" class="modal show" tabindex="-1" role="dialog" align="center" aria-modal="true"
            style="display: block;">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" id="closePopup" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <img src="{{ url($settings['logo'] ?? 'public/upload/logo.png') }}"
                            alt="{{ $settings['site_name'] ?? 'Site Logo' }}" class="img-fluid">
                        <a class="btn theme-btn mt-3" href="{{ $settings['youtube_video'] }}" target="_blank">
                            {{ $settings['PopupText'] }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const popup = document.getElementById('popup');
                const closeButton = document.getElementById('closePopup');

                // Display popup only if it wasn't closed before
                if (localStorage.getItem('popupClosed') !== 'true') {
                    popup.style.display = 'block';
                } else {
                    popup.style.display = 'none';
                }

                // Close popup and save state to localStorage
                closeButton.addEventListener('click', function() {
                    popup.style.display = 'none';
                    localStorage.setItem('popupClosed', 'true');
                });
            });
        </script>
    @endif





    @php
        $menus = App\Models\Menu::all();
    @endphp



    <div class="sticky-footer-container">
        @foreach ($menus as $menu)
            <div class="sticky-footer-item">
                <a href="{{ $menu->link }}">
                    <div class="d-flex justify-content-center align-items-center flex-column">
                        <span>{!! $menu->icon !!}</span>
                        <span>{{ $menu->name }}</span>
                    </div>
                </a>
            </div>
        @endforeach
    </div>



    </div>




@endsection
