@extends('frontend.master')


@php
    // Define the settings keys that you want to use in the welcome page
    $settingsKeys = [
        'site_title',
        'site_name',
        'meta_description',
        'meta_keywords',
        'og_image',
        'twitter_image',
        'favicon',
        'support_phone',
        'youtube_url',
        'notice_board',
        'messenger_url',
        'youtube_video',
    ];
    // Fetch these settings from the database
    $settings = App\Models\Setting::whereIn('key', $settingsKeys)->pluck('value', 'key');

@endphp



@section('css')
    @include('extra.snakbarcss')
@endsection
@section('content')
    <script src="{{ 'http://localhost/tipu/rexgamingbd2/public/frontend/assets/js/custom.js' }}"></script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <div class="container-fluid">
        <div class="col-sm-6 mx-auto" style="margin-top: 2px;">
            <div class="content_box_simple">
                <div class="body">
                    <table>
                        <div id="centerAlert" class="custom-alert d-none">
                            <div class="alert-content">
                                <p id="alertMessage"></p>
                                <button class="btn btn-primary" onclick="closeAlert()">OK</button>
                            </div>
                        </div>


                        <tbody>
                            <tr>
                                <td>
                                    <img class="product_thumbnail" src="{{ url('/') . '/' . $product->image }}"
                                        alt="Free Fire Topup" loading="lazy">
                                </td>
                                <td>
                                    <h2 class="product_heading_small">{{ $product->title }}</h2>
                                    <span class="produch_type">Game /
                                        {{ $product->type }}</span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <form method="POST" action="" id="myForm">
                @csrf

                @if ($product->type == 'topup')
                    <div class="content_box_simple">
                        <div class="heading">
                            <span class="heading_icon">A</span>
                            <span class="heading_title">
                                Account Info
                            </span>
                        </div>
                        <div class="body">
                            <label for="player_id">Player Id</label>
                            <input type="text" name="player_id" id="player_id" class="input_text player_id checkId"
                                placeholder="Enter player id">
                            <span id="player_id_error"></span>
                            <div class="idExist_container">
                                <span class="idExist"></span>
                            </div>
                            <button type="button" class="btn btn-aght theme-btn-block"
                                id="checkPlayerName">{{ __('Check Name') }}</button>
                            <div id="showName_By_player_id"></div>
                        </div>


                    </div>



                    <div class="content_box_simple" id="variation_list">
                        <div class="heading">
                            <span class="heading_icon">R</span>
                            <span class="heading_title">
                                Select Recharge
                            </span>
                        </div>
                        <div class="variation_body">
                            <div class="row">

                                @foreach ($variations as $variation)
                                    <div class="col-sm-4  col-6  equal-height">
                                        <div class="variation_list " id="{{ $variation->id }}"
                                            data-price="{{ $variation->price }}">
                                            <table>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <span class="variation_title">
                                                                {{ $variation->title }}
                                                            </span>
                                                        </td>
                                                        <td width="10%" class="text-right">
                                                            <div class="variation_price">
                                                                ৳{{ $variation->price }}</div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                @endforeach


                            </div>
                        </div>
                    </div>
                @endif

                @if ($product->type == 'ingame')
                    <div class="mb-3">
                        <label for="game_account_type" class="form-label">{{ __('Account Type') }}</label>
                        <select name="game_account_type" class="form-select" id="game_account_type">
                            <option value="gmail">Gmail</option>
                            <option value="facebook">Facebook</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="game_account" class="form-label">{{ __('Account') }}</label>
                        <input type="text" name="game_account" id="game_account" class="form-control game_account"
                            placeholder="Enter Email/Number" required>
                    </div>

                    <div class="mb-3">
                        <label for="game_password" class="form-label">{{ __('Password') }}</label>
                        <input type="text" name="game_password" id="game_password" class="form-control game_password"
                            placeholder="Enter Password" required>
                    </div>

                    <div class="mb-3">
                        <label for="game_backup" class="form-label">{{ __('Backup Code') }}</label>
                        <input type="text" name="game_backup" id="game_backup" class="form-control game_backup"
                            placeholder="Enter Backup Code">
                    </div>


                    <div class="content_box_simple" id="variation_list">
                        <div class="heading">
                            <span class="heading_icon">R</span>
                            <span class="heading_title">
                                Select Recharge
                            </span>
                        </div>
                        <div class="variation_body">
                            <div class="row">
                                @php
                                    $variations = App\Models\Variation::where('product_id', $product->id)->get();
                                @endphp

                                @foreach ($variations as $variation)
                                    <div class="col-sm-4 col-6 equal-height">
                                        <div class="variation_list" id="{{ $variation->id }}"
                                            data-price="{{ $variation->price }}">
                                            <table>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <span class="variation_title">
                                                                {{ $variation->title }}
                                                            </span>
                                                        </td>
                                                        <td width="10%" class="text-right">
                                                            <div class="variation_price">
                                                                ৳{{ $variation->price }}
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                @endforeach


                            </div>
                        </div>
                    </div>
                @endif


                @if ($product->type == 'voucher')
                    <div class="content_box_simple" id="variation_list">
                        <div class="heading">
                            <span class="heading_icon">R</span>
                            <span class="heading_title">
                                Select Recharge
                            </span>
                        </div>
                        <div class="variation_body">
                            <div class="row">

                                @foreach ($vouchers as $voucher)
                                    @php
                                        $variation = App\Models\Variation::where('id', $voucher->variation)->first();
                                    @endphp
                                    <div class="col-sm-4  col-12  equal-height">

                                        <div class="variation_list  {{ $variation->stock == 0 ? 'stockout' : '' }}"
                                            id="{{ $variation->id }}" data-price="150.00">
                                            <table>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <span class="variation_title">
                                                                {{ $variation->title }}
                                                            </span>
                                                        </td>
                                                        <td width="10%" class="text-right">
                                                            <div class="variation_price">
                                                                ৳{{ $variation->price }}</div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif

                <input type="hidden" name="variation_id" id="variation_id">
                <input type="hidden" name="variation_price" id="variation_price">
                <input type="hidden" name="payment_method" id="payment_method" value="wallet">



@if ($product->type == 'topup')
    <div class="content_box_simple_hde" style="display: none;">
@else
    <div class="content_box_simple_hde">

        <div class="content_box_simple_hde body d-flex justify-between align-middle quantity-container">
            <div><label>Quantity</label></div>
            <div style="margin-left: auto;">
                <div class="quantity-options">
                    <i class="fas fa-minus update-icon" id="decrease"></i>
                    <input type="number" name="quantity" class="form-control" id="quantity" value="1">
                    <i class="fas fa-plus update-icon" id="increase"></i>
                </div>
            </div>
        </div>
    </div>

@endif
                <div class="content_box_simple" id="payment_method_list">
                    <div class="heading">
                        <span class="heading_icon">P</span>
                        <span class="heading_title">
                            Select Payment
                        </span>
                    </div>
                    
                    <div class="pm_body">
                        <div class="row">
                            <div class="col-sm-4 col-6 equal-height">
                                <div class="pm_list selected_pm" id="wallet"><i
                                        class="selected_pm_icon fa-solid fa-check"></i>

                                   <img src="../public/assets/backend/images/wallete.png">
                                </div>
                            </div>
                            <div class="col-sm-4 col-6 equal-height">
                                <div class="pm_list" id="payment_gateway">

                                    <img src="../public/assets/backend/images/bkash.png">
                                    <div class="pm_title">Instant Pay</div>
                                </div>
                            </div>

                        </div>
                    </div>
                    
                </div>

                <div class="content_box_simple" id="add_money_instruction"
                    style="padding: 15px 15px 20px; font-size: 22px; display: none;">
                    <a href="{{ $settings['youtube_video'] ?? 'nai' }}" target="_blank">
                        <i class="fas fa-external-link-alt" style="margin-right: 5px;"></i>
                        কিভাবে Add Money করা ছাড়া অর্ডার করবেন?
                    </a>
                </div>


                @if (Auth::check() == false)
                    <div class="row" align="center" style="margin: -15px 0px 0px 0px;">
                        <a href="{{ url('login') }}">
                            <button type="button" class="btn btn-aght theme-btn-block">LOG IN</button>
                        </a>
                    </div>
                @else
                    <input type="hidden" name="type" value="{{ $product->type }}">
                    <div class="row" align="center" style="margin: -15px 0px 0px 0px;">
                        <a href="{{ url('user/fund') }}" class="btn btn-light col-12" id="add_fund">
                            Add Fund
                        </a>
                        <button type="button" id="storeOrder" class="btn btn-aght theme-btn-block">BUY
                            NOW
                        </button>
                    </div>
                    <div class="row" align="" style="margin: -25px 0px 0px 0px;">
                        <a class="btn btn-aght theme-btn-block" id="add_fund">
                            আপনার বর্তমান অ্যাকাউন্ট ব্যালেন্স {{ Auth::user()->balance }} টাকা। </a>
                    </div>
                @endif

            </form>

            <div class="content_box_simple">
                <div class="heading">
                    <span class="heading_icon">R</span>
                    <span class="heading_title">
                        Terms and Conditions
                    </span>
                </div>
                <div class="body">
                    <p>{!! nl2br(e($product->content)) !!}</p>
                </div>
            </div>
        </div>
    </div>

    {{-- 
    Ridoy added New  --}}
    @php
        $menus = App\Models\Menu::all();
    @endphp



    <div class="sticky-footer-container">
        @foreach ($menus as $menu)
            <div class="sticky-footer-item">
                <a href="{{ $menu->link }}">
                    <div class="d-flex justify-content-center align-items-center flex-column">
                        <span>{!! $menu->icon !!}</span>
                        <span>{{ $menu->name }}</span>
                    </div>
                </a>
            </div>
        @endforeach
    </div>










    @include('extra.snakbarjs')

    <script>
        $(document).ready(function() {
            $('#checkPlayerName').on('click', function() {
                // Get the Player ID from the input field
                var playerId = $('#player_id').val();

                if (playerId) {
                    // Perform an AJAX request to get player name
                    $.ajax({
                        url: 'https://hidetopup.com/lc/proxy.php', // The URL to make the request
                        method: 'GET',
                        data: {
                            uid: playerId
                        }, // Send the player ID as uid
                        success: function(response) {
                            // Assuming the API response contains a "name" field
                            if (response.message) {
                                // Display the player's name in the div
                                $('#showName_By_player_id').html(
                                    '<strong>Player Name:</strong> ' + response.message);
                            } else {
                                $('#showName_By_player_id').html(
                                    '<strong>No name found for this player ID.</strong>');
                            }
                        },
                        error: function() {
                            // Handle the error case
                            $('#showName_By_player_id').html(
                                '<strong>Failed to fetch player name.</strong>');
                        }
                    });
                } else {
                    // If the player ID is empty
                    $('#player_id_error').html('<strong>Please enter a valid Player ID.</strong>');
                }
            });
        });
    </script>





    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $('#storeOrder').on("click", function() {
            const button = $(this); // Reference the button
            button.prop('disabled', true); // Disable the button

            $.ajax({
                type: 'post',
                url: "{{ url('user/order') }}",
                data: $("#myForm").serialize(),
                success: function(res) {
                    if (res.message) {
                        toastr.success(res.message);
                    }
                    if (res.location) {
                        window.location.href = res.location;
                    } else {
                        // Re-enable the button after 2 second if no redirect happens
                        setTimeout(() => {
                            button.prop('disabled', false);
                        }, 2000);
                    }
                },
                error: function(xhr, status, error) {
                    const errorMessage = xhr.responseJSON && xhr.responseJSON.message ?
                        xhr.responseJSON.message :
                        "An unexpected error occurred.";
                    toastr.error(errorMessage); // Show the error message
                    console.log(error); // Log the error

                    // Re-enable the button after 2 second on error
                    setTimeout(() => {
                        button.prop('disabled', false);
                    }, 2000);
                }
            });
        });
    </script>





    <script>
        $(document).ready(function() {
            const $playerId = $('#player_id');
            const $playerIdError = $("#player_id_error");
            const $gameAccount = $('#game_account');
            const $gameAccountError = $("#game_account_error");
            const $gamePassword = $('#game_password');
            const $gamePasswordError = $("#game_password_error");
            const $addMoneyInstruction = $('#add_money_instruction');
            const $wallet = $('#wallet');
            const $walletBalance = $('#wallet_balance');
            const $variationId = $('#variation_id');
            const $variationPrice = $('#variation_price');
            const $totalCost = $('#total_cost');
            const $paymentMethod = $('#payment_method');
            const $quantityInput = $('#quantity');
            const $buyNow = $("#buy_now");
            const $addFund = $("#add_fund");

            function showError($element, message) {
                $element.html(`<div class='alert alert-white alert-p5 m-lr-7'>${message}</div>`);
            }

            function clearError($element) {
                $element.html("");
            }

            function handleInputError($input, $errorElement, message) {
                $input.on('keyup', function() {
                    if ($(this).val() === "") {
                        showError($errorElement, message);
                    } else {
                        clearError($errorElement);
                    }
                });
            }

            handleInputError($playerId, $playerIdError, "Player id required");
            handleInputError($gameAccount, $gameAccountError, "Gmail/number required");
            handleInputError($gamePassword, $gamePasswordError, "Password required");

            $('#payment_gateway').on('click', function() {
                $addMoneyInstruction.show();
            });

            $wallet.on('click', function() {
                $addMoneyInstruction.hide();
            });

            function selectVariation() {
                $('.variation_list').on('click', function() {
                    const $clickedVariation = $(this);
                    if (!$clickedVariation.hasClass('stockout')) {
                        $('.variation_list').removeClass('selected_variation');
                        $clickedVariation.addClass('selected_variation');
                        $('.selected_variation_icon').remove();
                        $clickedVariation.prepend(
                            '<i class="selected_variation_icon fa-solid fa-check"></i>');
                        $variationId.val($clickedVariation.attr('id'));
                        $variationPrice.val($clickedVariation.data('price'));
                        $totalCost.text($clickedVariation.data('price'));
                        checkWallet();
                    }
                });
            }

            function selectPaymentMethod() {
                $('.pm_list').on('click', function() {
                    const $clickedPM = $(this);
                    $('.pm_list').removeClass('selected_pm');
                    $clickedPM.addClass('selected_pm');
                    $('.selected_pm_icon').remove();
                    $clickedPM.prepend('<i class="selected_pm_icon fa-solid fa-check"></i>');
                    $paymentMethod.val($clickedPM.attr('id'));
                    checkWallet();
                });
            }

            function checkWallet() {
                const variationPrice = parseFloat($variationPrice.val());
                const paymentMethod = $paymentMethod.val();
                const walletBalance = parseFloat($walletBalance.text());

                if (!isNaN(variationPrice)) {
                    if (paymentMethod === "wallet" && variationPrice > walletBalance) {
                        disableBuyNow();
                    } else {
                        enableBuyNow();
                    }
                }
            }

            function disableBuyNow() {
                $buyNow.prop("disabled", true).html("Buy Now");
                $addFund.show();
            }

            function enableBuyNow() {
                $buyNow.prop("disabled", false).html("Buy Now");
                $addFund.hide();
            }

            function handleQuantityChange() {
                $(document).on('click', '.quantity-options i', function() {
                    let currentValue = parseInt($quantityInput.val());

                    if ($(this).is('#decrease') && currentValue > 1) {
                        $quantityInput.val(currentValue - 1);
                    } else if ($(this).is('#increase')) {
                        $quantityInput.val(currentValue + 1);
                    }

                    const unitCost = parseFloat($variationPrice.val());
                    const newQuantity = parseInt($quantityInput.val());
                    const newCost = unitCost * newQuantity;

                    $totalCost.text(newCost.toFixed(2));
                });
            }

            function initializePaymentMethod() {
                if ($walletBalance.text() !== "") {
                    if (parseFloat($walletBalance.text()) > 0) {
                        $wallet.click();
                    } else {
                        $('#payment_gateway').click();
                    }
                } else {
                    $wallet.click();
                }
            }

            // Initialize event handlers
            selectVariation();
            selectPaymentMethod();
            handleQuantityChange();
            initializePaymentMethod();
        });
    </script>
@endsection
