@extends('admin.admin_dashboard')
@section('admin')
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    $(document).ready(function() {
        // Initialize Select2 for the Variation field
        $('#variation-select').select2({
            placeholder: "Please select a variation",
            allowClear: true
        });

        // Auto-format textarea into multiple lines for voucher codes
        $('#voucher-textarea').on('input', function() {
            const input = $(this).val();
            // Ensure proper formatting: remove extra spaces and keep lines clean
            const formatted = input.split('\n').map(line => line.trim()).join('\n');
            $(this).val(formatted);
        });
    });
</script>

<style>
    /* Custom styling for the Select2 dropdown */
    .select2-container--default .select2-selection--single {
        background-color: #0c1427; /* Light background for better visibility */
        color: #ffffff; /* Dark text for better contrast */
        border: 1px solid #636ffa; /* Light border to define the edges */
        height: 38px; /* Make the dropdown box height match the form input field */
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #ffffff; /* Dark text color inside the selection */
        font-size: 16px; /* Set the text size */
    }

    .select2-container--default .select2-dropdown {
        background-color: #0c1427; /* Make the dropdown white for clarity */
        color: #ffffff; /* Dark text color */
        border: 1px solid #636ffa; /* Same border color for consistency */
        border-radius: 4px; /* Rounded corners for a smoother look */
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #0c1427; /* Ensure the search field has dark text */
    }
</style>

<div class="page-content">
    <div class="card shadow mb-4">
        @if (session()->has('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if (session()->has('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <div class="container-fluid">
            <div class="card-body">
                <form action="{{ route('admin.voucher.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-md-12">
                        <label>Variation</label>
                        <select name="variation" id="variation-select" class="form-control">
                            <option value="">Please select</option>
                            @foreach ($variations as $variation)
                                <option value="{{ $variation->id }}">{{ $variation->title }}</option>
                            @endforeach
                        </select>
                        @error('variation')
                            <span style="color: red;">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <div class="form-group col-md-12">
                        <label>Voucher Codes (One per line)</label>
                        <textarea name="codes" id="voucher-textarea" class="form-control" rows="5" placeholder="Paste voucher codes here, one per line"></textarea>
                        @error('codes')
                            <span style="color: red;">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection